"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepAboutRuleToggleDetails = void 0;
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _css = require("@emotion/css");
var _rule_about_section = require("../../../rule_management/components/rule_details/rule_about_section");
var _header_section = require("../../../../common/components/header_section");
var _markdown_editor = require("../../../../common/components/markdown_editor");
var i18n = _interopRequireWildcard(require("./translations"));
var _styles = require("./styles");
var _rule_field_name = require("../../../rule_management/components/rule_details/rule_field_name");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_creation/components/step_about_rule_details/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const detailsOption = {
  id: 'details',
  label: i18n.ABOUT_PANEL_DETAILS_TAB,
  'data-test-subj': 'stepAboutDetailsToggle-details'
};
const notesOption = {
  id: 'notes',
  label: i18n.ABOUT_PANEL_NOTES_TAB,
  'data-test-subj': 'stepAboutDetailsToggle-notes'
};
const setupOption = {
  id: 'setup',
  label: i18n.ABOUT_PANEL_SETUP_TAB,
  'data-test-subj': 'stepAboutDetailsToggle-setup'
};
const StepAboutRuleToggleDetailsComponent = ({
  stepData,
  stepDataDetails,
  loading,
  rule
}) => {
  const [selectedToggleOption, setToggleOption] = (0, _react.useState)('details');
  const [aboutPanelHeight, setAboutPanelHeight] = (0, _react.useState)(0);
  const onResize = (0, _react.useCallback)(e => {
    setAboutPanelHeight(e.height);
  }, [setAboutPanelHeight]);
  const toggleOptions = (0, _react.useMemo)(() => {
    const notesExist = !(0, _lodash.isEmpty)(stepDataDetails === null || stepDataDetails === void 0 ? void 0 : stepDataDetails.note) && (stepDataDetails === null || stepDataDetails === void 0 ? void 0 : stepDataDetails.note.trim()) !== '';
    const setupExists = !(0, _lodash.isEmpty)(stepDataDetails === null || stepDataDetails === void 0 ? void 0 : stepDataDetails.setup) && (stepDataDetails === null || stepDataDetails === void 0 ? void 0 : stepDataDetails.setup.trim()) !== '';
    return [...(notesExist || setupExists ? [detailsOption] : []), ...(notesExist ? [notesOption] : []), ...(setupExists ? [setupOption] : [])];
  }, [stepDataDetails === null || stepDataDetails === void 0 ? void 0 : stepDataDetails.note, stepDataDetails === null || stepDataDetails === void 0 ? void 0 : stepDataDetails.setup]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    className: (0, _css.css)`
        position: relative;
      `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 5
    }
  }, loading && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "accent",
    position: "absolute",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_header_section.HeaderSection, {
    title: i18n.ABOUT_TEXT,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 11
    }
  })), stepData != null && stepDataDetails != null && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    direction: "column",
    className: _styles.fullHeight,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    key: "header",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_header_section.HeaderSection, {
    title: i18n.ABOUT_TEXT,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 13
    }
  }, toggleOptions.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    options: toggleOptions,
    idSelected: selectedToggleOption,
    onChange: val => {
      setToggleOption(val);
    },
    "data-test-subj": "stepAboutDetailsToggle",
    legend: i18n.ABOUT_CONTROL_LEGEND,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: "details",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 11
    }
  }, selectedToggleOption === 'details' && /*#__PURE__*/_react.default.createElement(_eui.EuiResizeObserver, {
    "data-test-subj": "stepAboutDetailsContent",
    onResize: onResize,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 15
    }
  }, resizeRef => /*#__PURE__*/_react.default.createElement("div", {
    ref: resizeRef,
    className: _styles.fullHeight,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(VerticalOverflowContainer, {
    maxHeight: 120,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(VerticalOverflowContent, {
    maxHeight: 120,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(RuleDescription, {
    description: stepDataDetails.description,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 25
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 21
    }
  }), /*#__PURE__*/_react.default.createElement(_rule_about_section.RuleAboutSection, {
    rule: rule,
    hideName: true,
    hideDescription: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 21
    }
  }))), selectedToggleOption === 'notes' && /*#__PURE__*/_react.default.createElement(VerticalOverflowContainer, {
    maxHeight: aboutPanelHeight,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(VerticalOverflowContent, {
    maxHeight: aboutPanelHeight,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(RuleInvestigationGuide, {
    note: stepDataDetails.note,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 19
    }
  }))), selectedToggleOption === 'setup' && /*#__PURE__*/_react.default.createElement(VerticalOverflowContainer, {
    maxHeight: aboutPanelHeight,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(VerticalOverflowContent, {
    maxHeight: aboutPanelHeight,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(RuleSetupGuide, {
    setup: stepDataDetails.setup,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 19
    }
  }))))));
};
const StepAboutRuleToggleDetails = exports.StepAboutRuleToggleDetails = /*#__PURE__*/(0, _react.memo)(StepAboutRuleToggleDetailsComponent);
function VerticalOverflowContainer({
  maxHeight,
  children
}) {
  return /*#__PURE__*/_react.default.createElement("div", {
    className: (0, _css.css)`
        max-height: ${maxHeight}px;
        overflow-y: hidden;
        word-break: break-word;
      `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 5
    }
  }, children);
}
function VerticalOverflowContent({
  maxHeight,
  children
}) {
  return /*#__PURE__*/_react.default.createElement("div", {
    className: `eui-yScroll ${(0, _css.css)`
        max-height: ${maxHeight}px;
      `}`,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 5
    }
  }, children);
}
const RuleDescription = ({
  description
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
  listItems: [{
    title: /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
      label: i18n.ABOUT_PANEL_DESCRIPTION_LABEL,
      fieldName: "description",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 195,
        columnNumber: 16
      }
    }),
    description: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      "data-test-subj": "stepAboutRuleDetailsToggleDescriptionText",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 197,
        columnNumber: 11
      }
    }, description)
  }],
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 192,
    columnNumber: 3
  }
});
const RuleInvestigationGuide = ({
  note
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
  listItems: [{
    title: /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
      fieldName: "note",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 210,
        columnNumber: 16
      }
    }),
    description: /*#__PURE__*/_react.default.createElement(_markdown_editor.MarkdownRenderer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 211,
        columnNumber: 22
      }
    }, note)
  }],
  descriptionProps: {
    'data-test-subj': 'stepAboutDetailsNoteContent'
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 207,
    columnNumber: 3
  }
});
const RuleSetupGuide = ({
  setup
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
  listItems: [{
    title: /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
      fieldName: "setup",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 222,
        columnNumber: 16
      }
    }),
    description: /*#__PURE__*/_react.default.createElement(_markdown_editor.MarkdownRenderer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 223,
        columnNumber: 22
      }
    }, setup)
  }],
  descriptionProps: {
    'data-test-subj': 'stepAboutDetailsSetupContent'
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 219,
    columnNumber: 3
  }
});