"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addRequiredFieldRow = addRequiredFieldRow;
exports.createIndexPatternField = createIndexPatternField;
exports.getSelectToggleButtonForName = getSelectToggleButtonForName;
var _react = require("@testing-library/react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// eslint-disable-next-line import/no-extraneous-dependencies

function addRequiredFieldRow() {
  return (0, _react.act)(async () => {
    _react.fireEvent.click(_react.screen.getByText('Add required field'));
  });
}
function createIndexPatternField(overrides) {
  return {
    name: 'one',
    type: 'string',
    esTypes: [],
    ...overrides
  };
}
function getSelectToggleButtonForName(value) {
  return _react.screen.getByTestId(`requiredFieldNameSelect-${value}`).querySelector('[data-test-subj="comboBoxToggleListButton"]');
}