"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  isUrlInvalid: true,
  hasValueToDisplay: true
};
exports.hasValueToDisplay = hasValueToDisplay;
exports.isUrlInvalid = void 0;
var _fp = require("lodash/fp");
var _is_endpoint_host_isolated = require("./is_endpoint_host_isolated");
Object.keys(_is_endpoint_host_isolated).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _is_endpoint_host_isolated[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _is_endpoint_host_isolated[key];
    }
  });
});
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const allowedSchemes = ['http:', 'https:'];
const isUrlInvalid = url => {
  try {
    if (url != null) {
      if (url === '') {
        return false;
      } else {
        const urlParsed = new URL(url);
        if (allowedSchemes.includes(urlParsed.protocol) && url.startsWith(`${urlParsed.protocol}//`)) {
          return false;
        }
      }
    }
  } catch (error) {
    // intentionally left empty
  }
  return true;
};
exports.isUrlInvalid = isUrlInvalid;
function hasValueToDisplay(value) {
  return (0, _fp.isNumber)(value) || !(0, _fp.isEmpty)(value);
}