"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.searchEvents = void 0;
var _common = require("@kbn/kibana-utils-plugin/common");
var _rxjs = require("rxjs");
var _kibana = require("../../../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const searchEvents = async (signal, dataView, parameters) => {
  var _response$rawResponse, _response$rawResponse2, _response$rawResponse3, _response$rawResponse4;
  if (!dataView) {
    throw new Error('data view is not defined');
  }
  const {
    data
  } = _kibana.KibanaServices.get();
  const response = await (0, _rxjs.lastValueFrom)(data.search.search({
    params: {
      index: dataView.getIndexPattern(),
      body: {
        query: {
          ids: {
            values: parameters.eventIds
          }
        }
      },
      fields: ['*'],
      sort: parameters.sort.map(tableSort => ({
        [tableSort.columnId]: tableSort.sortDirection
      })),
      from: parameters.pageIndex * parameters.itemsPerPage,
      size: parameters.itemsPerPage
    }
  }));
  if (signal !== null && signal !== void 0 && signal.aborted) {
    throw new _common.AbortError();
  }
  return (_response$rawResponse = response === null || response === void 0 ? void 0 : (_response$rawResponse2 = response.rawResponse) === null || _response$rawResponse2 === void 0 ? void 0 : (_response$rawResponse3 = _response$rawResponse2.hits) === null || _response$rawResponse3 === void 0 ? void 0 : (_response$rawResponse4 = _response$rawResponse3.hits) === null || _response$rawResponse4 === void 0 ? void 0 : _response$rawResponse4.map(row => {
    var _row$fields;
    const ecs = {
      _id: row === null || row === void 0 ? void 0 : row._id,
      _index: row._index
    };
    return {
      _id: row._id,
      _index: row._index,
      ecs,
      data: [...Object.entries((_row$fields = row.fields) !== null && _row$fields !== void 0 ? _row$fields : {}).map(([field, value]) => ({
        field,
        value
      })), {
        field: '_id',
        value: [row._id]
      }]
    };
  })) !== null && _response$rawResponse !== void 0 ? _response$rawResponse : [];
};
exports.searchEvents = searchEvents;