"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInstallDataView = void 0;
var _reactQuery = require("@kbn/react-query");
var _i18n = require("@kbn/i18n");
var _use_asset_inventory_routes = require("../../../hooks/use_asset_inventory_routes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Hook with related business logic for installing Asset Inventory data view
 */
const useInstallDataView = ({
  callback
} = {}) => {
  var _mutation$error, _mutation$error$body;
  const {
    postInstallAssetInventoryDataView
  } = (0, _use_asset_inventory_routes.useAssetInventoryRoutes)();
  const mutation = (0, _reactQuery.useMutation)(postInstallAssetInventoryDataView, {
    onSuccess: () => {
      callback === null || callback === void 0 ? void 0 : callback();
    }
  });
  const errorMessage = ((_mutation$error = mutation.error) === null || _mutation$error === void 0 ? void 0 : (_mutation$error$body = _mutation$error.body) === null || _mutation$error$body === void 0 ? void 0 : _mutation$error$body.message) || _i18n.i18n.translate('xpack.securitySolution.assetInventory.onboarding.installDataView.error', {
    defaultMessage: 'Failed to install Asset Inventory data view. Please try again.'
  });

  // isInstalling is true when the mutation is loading and after it has succeeded so that the UI
  // can show a loading spinner while the status is being re-fetched
  const isInstalling = mutation.isLoading || mutation.isSuccess;
  return {
    isInstalling,
    error: mutation.isError ? errorMessage : null,
    reset: mutation.reset,
    installDataView: () => mutation.mutate()
  };
};
exports.useInstallDataView = useInstallDataView;