"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  EndpointStatus: true,
  HostStatus: true,
  ProtectionModes: true,
  AntivirusRegistrationModes: true,
  DeviceControlAccessLevel: true,
  HostPolicyResponseActionStatus: true,
  EndpointSortableField: true
};
exports.ProtectionModes = exports.HostStatus = exports.HostPolicyResponseActionStatus = exports.EndpointStatus = exports.EndpointSortableField = exports.DeviceControlAccessLevel = exports.AntivirusRegistrationModes = void 0;
var _actions = require("./actions");
Object.keys(_actions).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _actions[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _actions[key];
    }
  });
});
var _os = require("./os");
Object.keys(_os).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _os[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _os[key];
    }
  });
});
var _trusted_apps = require("./trusted_apps");
Object.keys(_trusted_apps).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _trusted_apps[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _trusted_apps[key];
    }
  });
});
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * Supported React-Router state for the Policy Details page
 */
/**
 * Object that allows you to maintain stateful information in the location object across navigation events
 *
 */
/**
 * A deep readonly type that will make all children of a given object readonly recursively
 */
/**
 * Utility type that will return back a union of the given [T]ype and an Immutable version of it
 */
/**
 * Stats for related events for a particular node in a resolver graph.
 */
/**
 * Represents the object structure of a returned document when using doc value fields to filter the fields
 * returned in a document from an Elasticsearch query.
 *
 * Here is an example:
 *
 * {
 *  "_index": ".ds-logs-endpoint.events.process-default-000001",
 *  "_id": "bc7brnUBxO0aE7QcCVHo",
 *  "_score": null,
 *  "fields": { <----------- The FieldsObject represents this portion
 *    "@timestamp": [
 *      "2020-11-09T21:13:25.246Z"
 *    ],
 *    "process.name": "explorer.exe",
 *    "process.parent.entity_id": [
 *      "0i17c2m22c"
 *    ],
 *    "process.Ext.ancestry": [ <------------ Notice that the keys are flattened
 *      "0i17c2m22c",
 *      "2z9j8dlx72",
 *      "oj61pr6g62",
 *      "x0leonbrc9"
 *    ],
 *    "process.entity_id": [
 *      "6k8waczi22"
 *    ]
 *  },
 *  "sort": [
 *    0,
 *    1604956405246
 *  ]
 * }
 */
/**
 * A node in a resolver graph.
 */
/**
 * The structure for a resolver graph that is generic and data type agnostic. The nodes in the graph do not conform
 * to a specific document type. The format of the nodes is defined by the schema used to query for the graph.
 */
/**
 * Response structure for the related events route.
 *
 * @deprecated use {@link ResolverNode} instead
 */
/**
 * Response structure for the events route.
 * `nextEvent` will be set to null when at the time of querying there were no more results to retrieve from ES.
 */
/**
 * Returned by the server via POST /api/endpoint/metadata
 */
/**
 * The data_stream fields in an elasticsearch document.
 */
/**
 * Operating System metadata.
 */
/**
 * Extended Operating System metadata.
 */
/**
 * Host metadata. Describes an endpoint host.
 */
/**
 * A record of hashes for something. Provides hashes in multiple formats. A favorite structure of the Elastic Endpoint.
 */
/**
 * Describes an Alert Event.
 */
/**
 * The status of the Endpoint Agent as reported by the Agent or the
 * Security Solution app using events from Fleet.
 */
let EndpointStatus = exports.EndpointStatus = /*#__PURE__*/function (EndpointStatus) {
  EndpointStatus["enrolled"] = "enrolled";
  EndpointStatus["unenrolled"] = "unenrolled";
  return EndpointStatus;
}({});
/**
 * The status of the host, which is mapped to the Elastic Agent status in Fleet
 */
let HostStatus = exports.HostStatus = /*#__PURE__*/function (HostStatus) {
  HostStatus["UNHEALTHY"] = "unhealthy";
  HostStatus["HEALTHY"] = "healthy";
  HostStatus["OFFLINE"] = "offline";
  HostStatus["UPDATING"] = "updating";
  HostStatus["INACTIVE"] = "inactive";
  HostStatus["UNENROLLED"] = "unenrolled";
  return HostStatus;
}({}); // Host Information as returned by the Host Details API.
// NOTE:The `HostInfo` type is the original and defined as Immutable.
// Host metadata document streamed up to ES by the Endpoint running on host machines.
// NOTE: The `HostMetadata` type is the original and defined as Immutable. If you need to
//        work with metadata that is not mutable, use `HostMetadataInterface`
/**
 * The persisted data (to the index) for both endpoint and agent data.
 * */
/**
 * All mappings in Elasticsearch support arrays. They can also return null values or be missing. For example, a `keyword` mapping could return `null` or `[null]` or `[]` or `'hi'`, or `['hi', 'there']`. We need to handle these cases in order to avoid throwing an error.
 * When dealing with an value that comes from ES, wrap the underlying type in `ECSField`. For example, if you have a `keyword` or `text` value coming from ES, cast it to `ECSField<string>`.
 */
/**
 * A more conservative version of `ResolverEvent` that treats fields as optional and use `ECSField` to type all ECS fields.
 * Prefer this over `ResolverEvent`.
 */
/**
 * A type for describing a winlog event until we can leverage runtime fields.
 */
/**
 * Safer version of ResolverEvent. Please use this going forward.
 */
/**
 * The fields to use to identify nodes within a resolver tree.
 */
/**
 * The response body for the resolver '/entity' index API
 */
/**
 * Takes a @kbn/config-schema 'schema' type and returns a type that represents valid inputs.
 * Similar to `TypeOf`, but allows strings as input for `schema.number()` (which is inline
 * with the behavior of the validator.) Also, for `schema.object`, when a value is a `schema.maybe`
 * the key will be marked optional (via `?`) so that you can omit keys for optional values.
 *
 * Use this when creating a value that will be passed to the schema.
 * e.g.
 * ```ts
 * const input: KbnConfigSchemaInputTypeOf<typeof schema> = value
 * schema.validate(input) // should be valid
 * ```
 * Note that because the types coming from `@kbn/config-schema`'s schemas sometimes have deeply nested
 * `Type` types, we process the result of `TypeOf` instead, as this will be consistent.
 */
/**
 * Works like ObjectResultType, except that 'maybe' schema will create an optional key.
 * This allows us to avoid passing 'maybeKey: undefined' when constructing such an object.
 *
 * Instead of using this directly, use `InputTypeOf`.
 */
/**
 * Takes the props of a schema.object type, and returns a version that excludes
 * optional values. Used by `InputObjectTypeOf`.
 *
 * Instead of using this directly, use `InputTypeOf`.
 */
/**
 * Endpoint Policy configuration
 */
/**
 * The set of Policy configuration settings that are show/edited via the UI
 */
/** Policy:  Protection fields */
/** Policy:  Supported fields */
/** Policy protection mode options */
let ProtectionModes = exports.ProtectionModes = /*#__PURE__*/function (ProtectionModes) {
  ProtectionModes["detect"] = "detect";
  ProtectionModes["prevent"] = "prevent";
  ProtectionModes["off"] = "off";
  return ProtectionModes;
}({});
let AntivirusRegistrationModes = exports.AntivirusRegistrationModes = /*#__PURE__*/function (AntivirusRegistrationModes) {
  AntivirusRegistrationModes["enabled"] = "enabled";
  AntivirusRegistrationModes["disabled"] = "disabled";
  AntivirusRegistrationModes["sync"] = "sync_with_malware_prevent";
  return AntivirusRegistrationModes;
}({});
const DeviceControlAccessLevel = exports.DeviceControlAccessLevel = {
  audit: 'audit',
  // read and write
  read_only: 'read_only',
  no_execute: 'no_execute',
  deny_all: 'deny_all'
};

/**
 * Endpoint Policy data, which extends Ingest's `PackagePolicy` type
 */

/**
 * New policy data. Used when updating the policy record via ingest APIs
 */
/**
 * the possible status for actions, configurations and overall Policy Response
 */
let HostPolicyResponseActionStatus = exports.HostPolicyResponseActionStatus = /*#__PURE__*/function (HostPolicyResponseActionStatus) {
  HostPolicyResponseActionStatus["success"] = "success";
  HostPolicyResponseActionStatus["failure"] = "failure";
  HostPolicyResponseActionStatus["warning"] = "warning";
  HostPolicyResponseActionStatus["unsupported"] = "unsupported";
  return HostPolicyResponseActionStatus;
}({});
/**
 * The name of actions that can be applied during the processing of a policy
 */
/**
 * Host Policy Response Applied Action
 */
/**
 * Host Policy Response Applied Artifact
 */
/**
 * Information about the applying of a policy to a given host
 */
/**
 * REST API response for retrieving a host's Policy Response status
 */
/**
 * REST API response for retrieving exception summary
 */
/**
 * Supported React-Router state for the Generic List page
 */
/** Allowed fields for sorting in the EndpointList table.
 * These are the column fields in the EndpointList table, based on the
 * returned `HostInfoInterface` data type (and not on the internal data structure).
 */
let EndpointSortableField = exports.EndpointSortableField = /*#__PURE__*/function (EndpointSortableField) {
  EndpointSortableField["ENROLLED_AT"] = "enrolled_at";
  EndpointSortableField["HOSTNAME"] = "metadata.host.hostname";
  EndpointSortableField["HOST_STATUS"] = "host_status";
  EndpointSortableField["POLICY_NAME"] = "metadata.Endpoint.policy.applied.name";
  EndpointSortableField["POLICY_STATUS"] = "metadata.Endpoint.policy.applied.status";
  EndpointSortableField["HOST_OS_NAME"] = "metadata.host.os.name";
  EndpointSortableField["HOST_IP"] = "metadata.host.ip";
  EndpointSortableField["AGENT_VERSION"] = "metadata.agent.version";
  EndpointSortableField["LAST_SEEN"] = "last_checkin";
  return EndpointSortableField;
}({});
/**
 * Returned by the server via GET /api/endpoint/metadata
 */