"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.attackDiscoveryProductFeaturesConfig = void 0;
var _actions = require("../actions");
var _product_features_keys = require("../product_features_keys");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * The Security solution RBAC framework MERGES (combines) these with the base
 * config defined in
 * `x-pack/solutions/security/packages/features/src/attack_discovery/kibana_features.ts`
 * to produce the final feature definition for the Attack Discovery feature.
 */
const attackDiscoveryProductFeaturesConfig = exports.attackDiscoveryProductFeaturesConfig = {
  [_product_features_keys.ProductFeatureAttackDiscoveryKey.attackDiscovery]: {
    privileges: {
      all: {
        api: [_actions.ATTACK_DISCOVERY_API_ACTION_ALL],
        // required in public API routes authz
        ui: ['attack-discovery']
      }
    },
    subFeatureIds: [_product_features_keys.AttackDiscoverySubFeatureId.updateSchedule]
  }
};