"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchUniqueRuleId = void 0;
var _uuid = require("uuid");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchUniqueRuleId = async (client, synonymsSetId) => {
  // Try to generate a unique rule ID arbitrary times
  for (let i = 0; i < 20; i++) {
    const randomizedId = `rule-${(0, _uuid.v4)().split('-')[4]}`;
    try {
      await client.synonyms.getSynonymRule({
        set_id: synonymsSetId,
        rule_id: randomizedId
      });
    } catch (e) {
      return randomizedId;
    }
  }
  throw new Error('Unable to generate a unique rule ID');
};
exports.fetchUniqueRuleId = fetchUniqueRuleId;