"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useShowManagedLLMCostTour = void 0;
var _react = require("react");
var _searchSharedUi = require("@kbn/search-shared-ui");
var _use_kibana = require("./use_kibana");
var _use_usage_tracker = require("./use_usage_tracker");
var _constants = require("../analytics/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useShowManagedLLMCostTour = () => {
  const usageTracker = (0, _use_usage_tracker.useUsageTracker)();
  const {
    cloud
  } = (0, _use_kibana.useKibana)().services;
  const [isTourVisible, setIsTourVisible] = (0, _react.useState)(false);
  const onSkipTour = (0, _react.useCallback)(() => {
    localStorage.setItem(_searchSharedUi.ELASTIC_LLM_COST_TOUR_SKIP_KEY, 'true');
    setIsTourVisible(false);
    usageTracker === null || usageTracker === void 0 ? void 0 : usageTracker.click(_constants.AnalyticsEvents.closedCostTransparencyTour);
  }, [usageTracker]);
  (0, _react.useEffect)(() => {
    var _cloud$isServerlessEn;
    const isTourSkipped = localStorage.getItem(_searchSharedUi.ELASTIC_LLM_COST_TOUR_SKIP_KEY) === 'true';
    const isCloud = (_cloud$isServerlessEn = cloud === null || cloud === void 0 ? void 0 : cloud.isServerlessEnabled) !== null && _cloud$isServerlessEn !== void 0 ? _cloud$isServerlessEn : false;
    if (!isTourSkipped && isCloud && !isTourVisible) {
      setIsTourVisible(true);
      usageTracker === null || usageTracker === void 0 ? void 0 : usageTracker.click(_constants.AnalyticsEvents.viewCostTransparencyTour);
    }
  }, [cloud, isTourVisible, usageTracker]);
  return {
    isTourVisible,
    onSkipTour
  };
};
exports.useShowManagedLLMCostTour = useShowManagedLLMCostTour;