"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UploadFileButton = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _fileUploadCommon = require("@kbn/file-upload-common");
var _use_kibana = require("../hooks/use_kibana");
var _use_source_indices_field = require("../hooks/use_source_indices_field");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_playground/public/components/upload_file_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const UploadFileButton = ({
  isSetup
}) => {
  const {
    services: {
      uiActions
    }
  } = (0, _use_kibana.useKibana)();
  const {
    setIndices: setSelectedIndices
  } = (0, _use_source_indices_field.useSourceIndicesFields)();
  const showFileUploadFlyout = _react.default.useCallback(() => {
    if (uiActions !== null) {
      uiActions.getTrigger(_fileUploadCommon.OPEN_FILE_UPLOAD_LITE_TRIGGER).exec({
        autoAddInference: '.elser-2-elasticsearch',
        onUploadComplete: results => {
          setSelectedIndices([results.index]);
        }
      });
    }
  }, [setSelectedIndices, uiActions]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isSetup ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    flush: "right",
    iconType: "importAction",
    onClick: () => showFileUploadFlyout(),
    "data-test-subj": "uploadFileButtonEmpty",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.setupPage.uploadFileButtonEmptyLabel",
    defaultMessage: "Upload a file",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 11
    }
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "text",
    size: "s",
    fill: false,
    iconType: "plusInCircle",
    onClick: () => showFileUploadFlyout(),
    "data-test-subj": "uploadFileButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.setupPage.uploadFileLabel",
    defaultMessage: "Upload file",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 11
    }
  })));
};
exports.UploadFileButton = UploadFileButton;