"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ContextFieldsSelect = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_playground/public/components/edit_context/context_fields_select.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ContextFieldsSelect = ({
  indexName,
  indexFields,
  selectedContextFields,
  updateSelectedContextFields
}) => {
  const searchValue = (0, _react.useRef)('');
  const [hasError, setHasError] = (0, _react.useState)(false);
  const handleSearchChange = value => {
    searchValue.current = value;
    setHasError(false);
  };
  const handleBlur = () => {
    if (searchValue.current.trim() === '') return;
    const hasExactMatch = selectOptions.some(opt => opt.label.toLowerCase() === searchValue.current.toLowerCase());
    setHasError(!hasExactMatch);
  };
  const {
    options: selectOptions,
    selectedOptions
  } = (0, _react.useMemo)(() => {
    var _indexFields$source_f, _selectedContextField, _selectedContextField2;
    if (!((_indexFields$source_f = indexFields.source_fields) !== null && _indexFields$source_f !== void 0 && _indexFields$source_f.length)) return {
      options: [],
      selectedOptions: []
    };
    const options = indexFields.source_fields.map(field => ({
      label: field,
      'data-test-subj': `contextField-${field}`
    }));
    const selected = (_selectedContextField = selectedContextFields === null || selectedContextFields === void 0 ? void 0 : (_selectedContextField2 = selectedContextFields.map(field => options.find(opt => opt.label === field))) === null || _selectedContextField2 === void 0 ? void 0 : _selectedContextField2.filter(val => val !== undefined)) !== null && _selectedContextField !== void 0 ? _selectedContextField : [];
    return {
      options,
      selectedOptions: selected
    };
  }, [indexFields.source_fields, selectedContextFields]);
  const onSelectFields = (0, _react.useCallback)(updatedSelectedOptions => {
    // always require at least 1 selected field
    if (updatedSelectedOptions.length === 0) return;
    updateSelectedContextFields(indexName, updatedSelectedOptions.map(opt => opt.label));
  }, [indexName, updateSelectedContextFields]);
  if (selectOptions.length === 0) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      announceOnMount: true,
      title: _i18n.i18n.translate('xpack.searchPlayground.editContext.noSourceFieldWarning', {
        defaultMessage: 'No source fields found'
      }),
      color: "warning",
      iconType: "warning",
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 83,
        columnNumber: 7
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    isInvalid: hasError,
    error: hasError ? `"${searchValue.current}" ${_i18n.i18n.translate('xpack.searchPlayground.editContext.noSourceFieldWarning', {
      defaultMessage: 'does not match any options'
    })}` : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "data-test-subj": `contextFieldsSelectable-${indexName}`,
    options: selectOptions,
    selectedOptions: selectedOptions,
    onChange: onSelectFields,
    isClearable: false,
    fullWidth: true,
    "aria-label": _i18n.i18n.translate('xpack.searchPlayground.editContext.ariaLabel', {
      defaultMessage: 'Select context field options'
    }),
    onSearchChange: handleSearchChange,
    onBlur: handleBlur,
    isInvalid: hasError,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 7
    }
  }));
};
exports.ContextFieldsSelect = ContextFieldsSelect;