"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteIndexModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _use_delete_index = require("../../hooks/api/use_delete_index");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_indices/public/components/indices/delete_index_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DeleteIndexModal = ({
  onCancel,
  indexName,
  navigateToIndexListPage
}) => {
  const {
    mutate,
    isLoading,
    isSuccess
  } = (0, _use_delete_index.useDeleteIndex)(indexName);
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  (0, _react.useEffect)(() => {
    if (isSuccess) {
      navigateToIndexListPage();
    }
  }, [navigateToIndexListPage, isSuccess]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "data-test-subj": "deleteIndexActionModal",
    "aria-labelledby": modalTitleId,
    title: _i18n.i18n.translate('xpack.searchIndices.indexActionsMenu.deleteIndex.confirmModal.modalTitle', {
      defaultMessage: 'Delete index'
    }),
    titleProps: {
      id: modalTitleId
    },
    onCancel: onCancel,
    onConfirm: () => mutate(),
    isLoading: isLoading,
    buttonColor: "danger",
    confirmButtonDisabled: false,
    cancelButtonText: _i18n.i18n.translate('xpack.searchIndices.indexActionsMenu.deleteIndex.confirmModal.cancelButtonText', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.searchIndices.indexActionsMenu.deleteIndex.confirmModal.confirmButtonText', {
      defaultMessage: 'Delete index'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchIndices.indexActionsMenu.deleteIndex.deleteDescription",
    defaultMessage: "You are about to delete this index:",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement("ul", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("li", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 11
    }
  }, indexName)), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchIndices.indexActionsMenu.deleteIndex.deleteWarningDescription",
    defaultMessage: "You can't recover a deleted index. Make sure you have appropriate backups.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 11
    }
  }))));
};
exports.DeleteIndexModal = DeleteIndexModal;