"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NavControl = NavControl;
exports.NavControlWithProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/observability-ai-assistant-plugin/public");
var _eui = require("@elastic/eui");
var _uuid = require("uuid");
var _useObservable2 = _interopRequireDefault(require("react-use/lib/useObservable"));
var _i18n = require("@kbn/i18n");
var _aiAssistant = require("@kbn/ai-assistant");
var _use_kibana = require("@kbn/ai-assistant/src/hooks/use_kibana");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _reactKibanaContextTheme = require("@kbn/react-kibana-context-theme");
var _sharedUxLinkRedirectApp = require("@kbn/shared-ux-link-redirect-app");
var _aiAssistantIcon = require("@kbn/ai-assistant-icon");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_assistant/public/components/nav_control/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const NavControlWithProvider = ({
  coreStart,
  pluginsStart
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiErrorBoundary, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_reactKibanaContextTheme.KibanaThemeProvider, {
    theme: coreStart.theme,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_public2.KibanaContextProvider, {
    services: {
      ...coreStart,
      ...pluginsStart
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
    coreStart: coreStart,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(coreStart.i18n.Context, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(NavControl, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 15
    }
  }))))));
};
exports.NavControlWithProvider = NavControlWithProvider;
function NavControl() {
  var _useObservable;
  const service = (0, _aiAssistant.useAIAssistantAppService)();
  const {
    services: {
      notifications,
      observabilityAIAssistant
    }
  } = (0, _use_kibana.useKibana)();
  const [hasBeenOpened, setHasBeenOpened] = (0, _react.useState)(false);
  const chatService = (0, _public.useAbortableAsync)(({
    signal
  }) => {
    return hasBeenOpened ? service.start({
      signal
    }).catch(error => {
      notifications === null || notifications === void 0 ? void 0 : notifications.toasts.addError(error, {
        title: _i18n.i18n.translate('xpack.searchAssistant.navControl.initFailureErrorTitle', {
          defaultMessage: 'Failed to initialize AI Assistant'
        })
      });
      setHasBeenOpened(false);
      setIsOpen(false);
      throw error;
    }) : undefined;
  }, [service, hasBeenOpened, notifications === null || notifications === void 0 ? void 0 : notifications.toasts]);
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  const keyRef = (0, _react.useRef)((0, _uuid.v4)());
  (0, _react.useEffect)(() => {
    const conversationSubscription = service.conversations.predefinedConversation$.subscribe(() => {
      keyRef.current = (0, _uuid.v4)();
      setHasBeenOpened(true);
      setIsOpen(true);
    });
    return () => {
      conversationSubscription.unsubscribe();
    };
  }, [service.conversations.predefinedConversation$]);
  const {
    messages,
    title
  } = (_useObservable = (0, _useObservable2.default)(service.conversations.predefinedConversation$)) !== null && _useObservable !== void 0 ? _useObservable : {
    messages: [],
    title: undefined
  };
  const tooltipRef = (0, _react.useRef)(null);
  const hideToolTip = () => {
    var _tooltipRef$current;
    return (_tooltipRef$current = tooltipRef.current) === null || _tooltipRef$current === void 0 ? void 0 : _tooltipRef$current.hideToolTip();
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: buttonLabel,
    ref: tooltipRef,
    onMouseOut: hideToolTip,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "aria-label": buttonLabel,
    "data-test-subj": "AiAssistantAppNavControlButton",
    onClick: () => {
      hideToolTip();
      service.conversations.openNewConversation({
        messages: []
      });
    },
    color: "primary",
    size: "s",
    iconType: _aiAssistantIcon.AssistantIcon,
    isLoading: chatService.loading,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.searchAssistant.navControl.assistantNavLink', {
    defaultMessage: 'AI Assistant'
  }))), chatService.value && Boolean(observabilityAIAssistant === null || observabilityAIAssistant === void 0 ? void 0 : observabilityAIAssistant.ObservabilityAIAssistantChatServiceContext) ? /*#__PURE__*/_react.default.createElement(observabilityAIAssistant.ObservabilityAIAssistantChatServiceContext.Provider, {
    value: chatService.value,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_aiAssistant.ChatFlyout, {
    key: keyRef.current,
    isOpen: isOpen,
    initialMessages: messages,
    initialTitle: title !== null && title !== void 0 ? title : '',
    onClose: () => {
      setIsOpen(false);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 11
    }
  })) : undefined);
}
const isMac = navigator.userAgent.toLocaleLowerCase().includes('mac');
const buttonLabel = _i18n.i18n.translate('xpack.searchAssistant.navControl.openTheAIAssistantPopoverLabel', {
  defaultMessage: 'Keyboard shortcut {keyboardShortcut}',
  values: {
    keyboardShortcut: isMac ? '⌘ ;' : 'Ctrl ;'
  }
});