"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toSavedSearchAttributes = exports.fromSavedSearchAttributes = void 0;
var _lodash = require("lodash");
var _saved_searches_utils = require("../saved_searches_utils");
var _extract_tabs = require("./extract_tabs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const fromSavedSearchAttributes = (id, attributes, tags, references, searchSource, sharingSavedObjectProps, managed, serialized = false) => ({
  ...(0, _saved_searches_utils.fromSavedSearchAttributes)(id, attributes, tags, searchSource, managed, serialized),
  sharingSavedObjectProps,
  references
});
exports.fromSavedSearchAttributes = fromSavedSearchAttributes;
const toSavedSearchAttributes = (savedSearch, searchSourceJSON) => {
  var _savedSearch$title, _savedSearch$sort, _savedSearch$columns, _savedSearch$descript, _savedSearch$grid, _savedSearch$hideChar, _savedSearch$isTextBa, _savedSearch$timeRest;
  return (0, _extract_tabs.extractTabs)({
    kibanaSavedObjectMeta: {
      searchSourceJSON
    },
    title: (_savedSearch$title = savedSearch.title) !== null && _savedSearch$title !== void 0 ? _savedSearch$title : '',
    sort: (_savedSearch$sort = savedSearch.sort) !== null && _savedSearch$sort !== void 0 ? _savedSearch$sort : [],
    columns: (_savedSearch$columns = savedSearch.columns) !== null && _savedSearch$columns !== void 0 ? _savedSearch$columns : [],
    description: (_savedSearch$descript = savedSearch.description) !== null && _savedSearch$descript !== void 0 ? _savedSearch$descript : '',
    grid: (_savedSearch$grid = savedSearch.grid) !== null && _savedSearch$grid !== void 0 ? _savedSearch$grid : {},
    hideChart: (_savedSearch$hideChar = savedSearch.hideChart) !== null && _savedSearch$hideChar !== void 0 ? _savedSearch$hideChar : false,
    viewMode: savedSearch.viewMode,
    hideAggregatedPreview: savedSearch.hideAggregatedPreview,
    rowHeight: savedSearch.rowHeight,
    headerRowHeight: savedSearch.headerRowHeight,
    isTextBasedQuery: (_savedSearch$isTextBa = savedSearch.isTextBasedQuery) !== null && _savedSearch$isTextBa !== void 0 ? _savedSearch$isTextBa : false,
    usesAdHocDataView: savedSearch.usesAdHocDataView,
    controlGroupJson: savedSearch.controlGroupJson,
    timeRestore: (_savedSearch$timeRest = savedSearch.timeRestore) !== null && _savedSearch$timeRest !== void 0 ? _savedSearch$timeRest : false,
    timeRange: savedSearch.timeRange ? (0, _lodash.pick)(savedSearch.timeRange, ['from', 'to']) : undefined,
    refreshInterval: savedSearch.refreshInterval,
    rowsPerPage: savedSearch.rowsPerPage,
    sampleSize: savedSearch.sampleSize,
    density: savedSearch.density,
    breakdownField: savedSearch.breakdownField,
    visContext: savedSearch.visContext
  });
};
exports.toSavedSearchAttributes = toSavedSearchAttributes;