"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ImportSummary = void 0;
var _lodash = _interopRequireDefault(require("lodash"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _use_memo_css = require("@kbn/css-utils/public/use_memo_css");
var _react2 = require("@emotion/react");
var _lib = require("../../../lib");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/saved_objects_management/public/management_section/objects_table/components/import_summary.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DEFAULT_ICON = 'apps';
const unsupportedTypeErrorMessage = _i18n.i18n.translate('savedObjectsManagement.objectsTable.importSummary.unsupportedTypeError', {
  defaultMessage: 'Unsupported object type'
});
const getErrorMessage = ({
  error
}) => {
  if (error.type === 'unknown') {
    return error.message;
  } else if (error.type === 'unsupported_type') {
    return unsupportedTypeErrorMessage;
  }
};
const mapFailedImport = failure => {
  const {
    obj
  } = failure;
  const {
    type,
    id,
    meta
  } = obj;
  const title = meta.title || (0, _lib.getDefaultTitle)(obj);
  const icon = meta.icon || DEFAULT_ICON;
  const errorMessage = getErrorMessage(failure);
  return {
    type,
    id,
    title,
    icon,
    outcome: 'error',
    errorMessage
  };
};
const mapImportSuccess = obj => {
  const {
    type,
    id,
    meta,
    overwrite
  } = obj;
  const title = meta.title || (0, _lib.getDefaultTitle)(obj);
  const icon = meta.icon || DEFAULT_ICON;
  const outcome = overwrite ? 'overwritten' : 'created';
  return {
    type,
    id,
    title,
    icon,
    outcome
  };
};
const CountIndicators = ({
  importItems
}) => {
  const styles = (0, _use_memo_css.useMemoCss)(componentStyles);
  if (!importItems.length) {
    return null;
  }
  const outcomeCounts = importItems.reduce((acc, {
    outcome
  }) => {
    var _acc$get;
    return acc.set(outcome, ((_acc$get = acc.get(outcome)) !== null && _acc$get !== void 0 ? _acc$get : 0) + 1);
  }, new Map());
  const createdCount = outcomeCounts.get('created');
  const overwrittenCount = outcomeCounts.get('overwritten');
  const errorCount = outcomeCounts.get('error');
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 5
    }
  }, createdCount && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    css: styles.createdCount,
    "data-test-subj": "importSavedObjectsCreatedCount",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "savedObjectsManagement.importSummary.createdCountHeader",
    defaultMessage: "{createdCount} new",
    values: {
      createdCount
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 15
    }
  })))), overwrittenCount && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    "data-test-subj": "importSavedObjectsOverwrittenCount",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "savedObjectsManagement.importSummary.overwrittenCountHeader",
    defaultMessage: "{overwrittenCount} overwritten",
    values: {
      overwrittenCount
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 15
    }
  })))), errorCount && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    "data-test-subj": "importSavedObjectsErrorsCount",
    css: styles.errorCount,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "savedObjectsManagement.importSummary.errorCountHeader",
    defaultMessage: "{errorCount} error",
    values: {
      errorCount
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 15
    }
  })))));
};
const StatusIndicator = ({
  item
}) => {
  const {
    outcome,
    errorMessage = 'Error'
  } = item;
  switch (outcome) {
    case 'created':
      return /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        type: 'checkInCircleFilled',
        color: 'success',
        content: _i18n.i18n.translate('savedObjectsManagement.importSummary.createdOutcomeLabel', {
          defaultMessage: 'Created'
        }),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 152,
          columnNumber: 9
        }
      });
    case 'overwritten':
      return /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        type: 'check',
        content: _i18n.i18n.translate('savedObjectsManagement.importSummary.overwrittenOutcomeLabel', {
          defaultMessage: 'Overwritten'
        }),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 162,
          columnNumber: 9
        }
      });
    case 'error':
      return /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        type: 'error',
        color: 'danger',
        content: _i18n.i18n.translate('savedObjectsManagement.importSummary.errorOutcomeLabel', {
          defaultMessage: '{errorMessage}',
          values: {
            errorMessage
          }
        }),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 171,
          columnNumber: 9
        }
      });
  }
};
const ImportWarnings = ({
  warnings,
  basePath
}) => {
  if (!warnings.length) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 7
    }
  }), warnings.map((warning, index) => /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    key: `warning-${index}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(ImportWarning, {
    warning: warning,
    basePath: basePath,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 11
    }
  }), index < warnings.length - 1 && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 43
    }
  }))));
};
const ImportWarning = ({
  warning,
  basePath
}) => {
  const warningContent = (0, _react.useMemo)(() => {
    if (warning.type === 'action_required') {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "flexEnd",
        justifyContent: "flexEnd",
        gutterSize: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 211,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 212,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        size: "s",
        color: "warning",
        href: basePath.prepend(warning.actionPath),
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 213,
          columnNumber: 13
        }
      }, warning.buttonLabel || /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "savedObjectsManagement.importSummary.warnings.defaultButtonLabel",
        defaultMessage: "Go",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 220,
          columnNumber: 17
        }
      }))));
    }
    return null;
  }, [warning, basePath]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    size: "s",
    iconType: "warning",
    "data-test-subj": "importSavedObjectsWarning",
    title: warning.message,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 234,
      columnNumber: 5
    }
  }, warningContent);
};
const ImportSummary = ({
  failedImports,
  successfulImports,
  importWarnings,
  basePath,
  allowedTypes
}) => {
  const importItems = (0, _react.useMemo)(() => _lodash.default.sortBy([...failedImports.map(x => mapFailedImport(x)), ...successfulImports.map(x => mapImportSuccess(x))], ['type', 'title']), [successfulImports, failedImports]);
  const styles = (0, _use_memo_css.useMemoCss)(componentStyles);
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 267,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    "data-test-subj": importItems.length ? 'importSavedObjectsSuccess' : 'importSavedObjectsSuccessNoneImported',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 268,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 274,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "savedObjectsManagement.importSummary.headerLabel",
    defaultMessage: "{importCount, plural, one {1 object} other {# objects}} imported",
    values: {
      importCount: importItems.length
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 275,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 282,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(CountIndicators, {
    importItems: importItems,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 283,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(ImportWarnings, {
    warnings: importWarnings,
    basePath: basePath,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 284,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 285,
      columnNumber: 7
    }
  }), importItems.map((item, index) => {
    const {
      type,
      title,
      icon
    } = item;
    const typeLabel = (0, _lib.getSavedObjectLabel)(type, allowedTypes);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      responsive: false,
      key: index,
      alignItems: "center",
      gutterSize: "s",
      css: styles.row,
      "data-test-subj": "importSavedObjectsRow",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 290,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 298,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: typeLabel,
      position: "top",
      "aria-label": typeLabel,
      type: icon,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 299,
        columnNumber: 15
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      css: styles.title,
      "data-test-subj": "importSavedObjectsTitle",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 301,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 302,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      className: "eui-textTruncate",
      title: title,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 303,
        columnNumber: 17
      }
    }, title))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 308,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "eui-textRight",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 309,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(StatusIndicator, {
      item: item,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 310,
        columnNumber: 17
      }
    }))));
  }));
};
exports.ImportSummary = ImportSummary;
const componentStyles = {
  row: ({
    euiTheme
  }) => (0, _react2.css)({
    marginBottom: euiTheme.size.xs
  }),
  title: (0, _react2.css)({
    minWidth: 0
  }),
  createdCount: ({
    euiTheme
  }) => (0, _react2.css)({
    color: euiTheme.colors.textSuccess
  }),
  errorCount: ({
    euiTheme
  }) => (0, _react2.css)({
    color: euiTheme.colors.textDanger
  })
};