"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerReportingEventTypes = registerReportingEventTypes;
var _reportingServer = require("@kbn/reporting-server");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fields = {
  [_reportingServer.FieldType.REPORT_ID]: {
    [_reportingServer.FieldType.REPORT_ID]: {
      type: 'keyword',
      _meta: {
        description: 'The ID of the report job, for correlating multiple events.'
      }
    }
  },
  [_reportingServer.FieldType.EXPORT_TYPE]: {
    [_reportingServer.FieldType.EXPORT_TYPE]: {
      type: 'keyword',
      _meta: {
        description: 'The type of export format: CSV, PNG, PDF.'
      }
    }
  },
  [_reportingServer.FieldType.OBJECT_TYPE]: {
    [_reportingServer.FieldType.OBJECT_TYPE]: {
      type: 'keyword',
      _meta: {
        description: 'The type of object being exported: Dashboard, Lens, Canvas, Search.'
      }
    }
  },
  [_reportingServer.FieldType.IS_DEPRECATED]: {
    [_reportingServer.FieldType.IS_DEPRECATED]: {
      type: 'boolean',
      _meta: {
        description: 'Whether the export type is deprecated.'
      }
    }
  },
  [_reportingServer.FieldType.IS_PUBLIC_API]: {
    [_reportingServer.FieldType.IS_PUBLIC_API]: {
      type: 'boolean',
      _meta: {
        description: 'Whether the public API was used to request the report, vs the internal API.'
      }
    }
  },
  [_reportingServer.FieldType.DURATION_MS]: {
    [_reportingServer.FieldType.DURATION_MS]: {
      type: 'long',
      _meta: {
        description: 'The number of milliseconds of time taken for the event from start to finish.'
      }
    }
  },
  [_reportingServer.FieldType.ERROR_CODE]: {
    [_reportingServer.FieldType.ERROR_CODE]: {
      type: 'keyword',
      _meta: {
        description: 'An indicator of a type of error.'
      }
    }
  },
  [_reportingServer.FieldType.ERROR_MESSAGE]: {
    [_reportingServer.FieldType.ERROR_MESSAGE]: {
      type: 'keyword',
      _meta: {
        description: 'A message from an error that was caught.'
      }
    }
  },
  [_reportingServer.FieldType.BYTE_SIZE]: {
    [_reportingServer.FieldType.BYTE_SIZE]: {
      type: 'long',
      _meta: {
        description: 'The size in bytes of the export.'
      }
    }
  },
  [_reportingServer.FieldType.NUM_PAGES]: {
    [_reportingServer.FieldType.NUM_PAGES]: {
      type: 'long',
      _meta: {
        description: 'The number of pages in a PDF export.'
      }
    }
  },
  [_reportingServer.FieldType.SCREENSHOT_LAYOUT]: {
    [_reportingServer.FieldType.SCREENSHOT_LAYOUT]: {
      type: 'keyword',
      _meta: {
        description: 'The type of layout used for PDF export: print, preserve, canvas'
      }
    }
  },
  [_reportingServer.FieldType.SCREENSHOT_PIXELS]: {
    [_reportingServer.FieldType.SCREENSHOT_PIXELS]: {
      type: 'long',
      _meta: {
        description: 'The number of pixels captured in the PNG or PDF export.'
      }
    }
  },
  [_reportingServer.FieldType.CSV_ROWS]: {
    [_reportingServer.FieldType.CSV_ROWS]: {
      type: 'long',
      _meta: {
        description: 'The number of rows exported in CSV.'
      }
    }
  },
  [_reportingServer.FieldType.SCHEDULE_TYPE]: {
    [_reportingServer.FieldType.SCHEDULE_TYPE]: {
      type: 'keyword',
      _meta: {
        description: 'The type of export: single, scheduled.'
      }
    }
  },
  [_reportingServer.FieldType.ATTEMPT]: {
    [_reportingServer.FieldType.ATTEMPT]: {
      type: 'long',
      _meta: {
        optional: true,
        description: 'Which attempt this execution succeeded on, starting at 1.'
      }
    }
  },
  [_reportingServer.FieldType.SCHEDULED_TASK_ID]: {
    [_reportingServer.FieldType.SCHEDULED_TASK_ID]: {
      type: 'keyword',
      _meta: {
        optional: true,
        description: 'The id of the scheduled report task.'
      }
    }
  },
  // TODO: not used
  [_reportingServer.FieldType.CSV_COLUMNS]: {
    [_reportingServer.FieldType.CSV_COLUMNS]: {
      type: 'long',
      _meta: {
        description: 'The number of columns exported in CSV.'
      }
    }
  }
};
const eventTypes = [{
  eventType: _reportingServer.EventType.REPORT_CREATION,
  schema: {
    ...fields[_reportingServer.FieldType.REPORT_ID],
    ...fields[_reportingServer.FieldType.EXPORT_TYPE],
    ...fields[_reportingServer.FieldType.OBJECT_TYPE],
    ...fields[_reportingServer.FieldType.IS_DEPRECATED],
    ...fields[_reportingServer.FieldType.IS_PUBLIC_API],
    ...fields[_reportingServer.FieldType.SCHEDULE_TYPE]
  }
}, {
  eventType: _reportingServer.EventType.REPORT_CLAIM,
  schema: {
    ...fields[_reportingServer.FieldType.REPORT_ID],
    ...fields[_reportingServer.FieldType.SCHEDULED_TASK_ID],
    ...fields[_reportingServer.FieldType.EXPORT_TYPE],
    ...fields[_reportingServer.FieldType.OBJECT_TYPE],
    ...fields[_reportingServer.FieldType.DURATION_MS],
    ...fields[_reportingServer.FieldType.SCHEDULE_TYPE]
  }
}, {
  eventType: _reportingServer.EventType.REPORT_COMPLETION_CSV,
  schema: {
    ...fields[_reportingServer.FieldType.REPORT_ID],
    ...fields[_reportingServer.FieldType.SCHEDULED_TASK_ID],
    ...fields[_reportingServer.FieldType.EXPORT_TYPE],
    ...fields[_reportingServer.FieldType.OBJECT_TYPE],
    ...fields[_reportingServer.FieldType.DURATION_MS],
    ...fields[_reportingServer.FieldType.BYTE_SIZE],
    ...fields[_reportingServer.FieldType.CSV_ROWS],
    ...fields[_reportingServer.FieldType.SCHEDULE_TYPE],
    ...fields[_reportingServer.FieldType.ATTEMPT]
    // ...fields[FieldType.CSV_COLUMNS], // TODO add to report output metrics
  }
}, {
  eventType: _reportingServer.EventType.REPORT_COMPLETION_SCREENSHOT,
  schema: {
    ...fields[_reportingServer.FieldType.REPORT_ID],
    ...fields[_reportingServer.FieldType.SCHEDULED_TASK_ID],
    ...fields[_reportingServer.FieldType.EXPORT_TYPE],
    ...fields[_reportingServer.FieldType.OBJECT_TYPE],
    ...fields[_reportingServer.FieldType.DURATION_MS],
    ...fields[_reportingServer.FieldType.BYTE_SIZE],
    ...fields[_reportingServer.FieldType.NUM_PAGES],
    ...fields[_reportingServer.FieldType.SCREENSHOT_LAYOUT],
    ...fields[_reportingServer.FieldType.SCREENSHOT_PIXELS],
    ...fields[_reportingServer.FieldType.SCHEDULE_TYPE],
    ...fields[_reportingServer.FieldType.ATTEMPT]
  }
}, {
  eventType: _reportingServer.EventType.REPORT_ERROR,
  schema: {
    ...fields[_reportingServer.FieldType.REPORT_ID],
    ...fields[_reportingServer.FieldType.SCHEDULED_TASK_ID],
    ...fields[_reportingServer.FieldType.EXPORT_TYPE],
    ...fields[_reportingServer.FieldType.OBJECT_TYPE],
    ...fields[_reportingServer.FieldType.DURATION_MS],
    ...fields[_reportingServer.FieldType.SCHEDULE_TYPE],
    ...fields[_reportingServer.FieldType.ERROR_CODE],
    ...fields[_reportingServer.FieldType.ERROR_MESSAGE]
  }
}, {
  eventType: _reportingServer.EventType.REPORT_DOWNLOAD,
  schema: {
    ...fields[_reportingServer.FieldType.REPORT_ID],
    ...fields[_reportingServer.FieldType.EXPORT_TYPE],
    ...fields[_reportingServer.FieldType.OBJECT_TYPE],
    ...fields[_reportingServer.FieldType.DURATION_MS]
  }
}, {
  eventType: _reportingServer.EventType.REPORT_DELETION,
  schema: {
    ...fields[_reportingServer.FieldType.REPORT_ID],
    ...fields[_reportingServer.FieldType.EXPORT_TYPE],
    ...fields[_reportingServer.FieldType.OBJECT_TYPE],
    ...fields[_reportingServer.FieldType.DURATION_MS]
  }
}, {
  eventType: _reportingServer.EventType.REPORT_NOTIFICATION,
  schema: {
    ...fields[_reportingServer.FieldType.REPORT_ID],
    ...fields[_reportingServer.FieldType.SCHEDULED_TASK_ID],
    ...fields[_reportingServer.FieldType.EXPORT_TYPE],
    ...fields[_reportingServer.FieldType.OBJECT_TYPE],
    ...fields[_reportingServer.FieldType.BYTE_SIZE],
    ...fields[_reportingServer.FieldType.SCHEDULE_TYPE]
  }
}, {
  eventType: _reportingServer.EventType.REPORT_NOTIFICATION_ERROR,
  schema: {
    ...fields[_reportingServer.FieldType.REPORT_ID],
    ...fields[_reportingServer.FieldType.SCHEDULED_TASK_ID],
    ...fields[_reportingServer.FieldType.EXPORT_TYPE],
    ...fields[_reportingServer.FieldType.OBJECT_TYPE],
    ...fields[_reportingServer.FieldType.SCHEDULE_TYPE],
    ...fields[_reportingServer.FieldType.BYTE_SIZE],
    ...fields[_reportingServer.FieldType.ERROR_MESSAGE]
  }
}];
function registerReportingEventTypes(core) {
  const {
    analytics
  } = core;
  for (const eventType of eventTypes) {
    analytics.registerEventType(eventType);
  }
}