"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RedirectApp = void 0;
var _queryString = require("query-string");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _reportingCommon = require("@kbn/reporting-common");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/reporting/public/redirect/redirect_app.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const i18nTexts = {
  errorTitle: _i18n.i18n.translate('xpack.reporting.redirectApp.errorTitle', {
    defaultMessage: 'Redirect error'
  }),
  consoleMessagePrefix: _i18n.i18n.translate('xpack.reporting.redirectApp.redirectConsoleErrorPrefixLabel', {
    defaultMessage: 'Redirect page error:'
  })
};
const RedirectApp = ({
  apiClient,
  screenshotMode,
  share
}) => {
  const [error, setError] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    (async () => {
      try {
        let locatorParams;
        const {
          jobId,
          scheduledReportId,
          page,
          perPage
        } = (0, _queryString.parse)(window.location.search);
        if (scheduledReportId) {
          var _scheduledReport$payl, _scheduledReport$payl2;
          const scheduledReport = await apiClient.getScheduledReportInfo(scheduledReportId, parseInt(page, 10), parseInt(perPage, 10));
          locatorParams = scheduledReport === null || scheduledReport === void 0 ? void 0 : (_scheduledReport$payl = scheduledReport.payload) === null || _scheduledReport$payl === void 0 ? void 0 : (_scheduledReport$payl2 = _scheduledReport$payl.locatorParams) === null || _scheduledReport$payl2 === void 0 ? void 0 : _scheduledReport$payl2[0];
        } else if (jobId) {
          var _result$locatorParams;
          const result = await apiClient.getInfo(jobId);
          locatorParams = result === null || result === void 0 ? void 0 : (_result$locatorParams = result.locatorParams) === null || _result$locatorParams === void 0 ? void 0 : _result$locatorParams[0];
        } else {
          locatorParams = screenshotMode.getScreenshotContext(_reportingCommon.REPORTING_REDIRECT_LOCATOR_STORE_KEY);
        }
        if (!locatorParams) {
          throw new Error('Could not find locator params for report');
        }
        if (!_reportingCommon.REPORTING_REDIRECT_ALLOWED_LOCATOR_TYPES.includes(locatorParams.id)) {
          // eslint-disable-next-line no-console
          console.error(`Report job execution cannot redirect using ${locatorParams.id}`);
          throw new Error('Report job execution can only redirect using a locator for an expected analytical app');
        }
        share.navigate(locatorParams);
      } catch (e) {
        setError(e);
        // eslint-disable-next-line no-console
        console.error(i18nTexts.consoleMessagePrefix, e.message);
      }
    })();
  }, [apiClient, screenshotMode, share]);
  return /*#__PURE__*/_react.default.createElement("div", {
    css: ({
      euiTheme
    }) => (0, _react2.css)({
      // Create some padding above and below the page so that the errors (if any) display nicely.
      margin: `${euiTheme.size.xxl} auto`
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 5
    }
  }, error ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: i18nTexts.errorTitle,
    color: "danger",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 11
    }
  }, error.message), error.stack && /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 27
    }
  }, error.stack)) :
  /*#__PURE__*/
  // We don't show anything on this page, the share service will handle showing any issues with
  // using the locator
  _react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 9
    }
  }));
};
exports.RedirectApp = RedirectApp;