"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIndexMappingsTool = void 0;
var _zod = require("@kbn/zod");
var _onechatCommon = require("@kbn/onechat-common");
var _onechatGenaiUtils = require("@kbn/onechat-genai-utils");
var _tool_result = require("@kbn/onechat-common/tools/tool_result");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getIndexMappingsSchema = _zod.z.object({
  indices: _zod.z.array(_zod.z.string()).min(1).describe('List of indices to retrieve mappings for.')
});
const getIndexMappingsTool = () => {
  return {
    id: _onechatCommon.platformCoreTools.getIndexMapping,
    type: _onechatCommon.ToolType.builtin,
    description: 'Retrieve mappings for the specified index or indices.',
    schema: getIndexMappingsSchema,
    handler: async ({
      indices
    }, {
      esClient
    }) => {
      const result = await (0, _onechatGenaiUtils.getIndexMappings)({
        indices,
        esClient: esClient.asCurrentUser
      });
      return {
        results: [{
          type: _tool_result.ToolResultType.other,
          data: {
            mappings: result,
            indices
          }
        }]
      };
    },
    tags: []
  };
};
exports.getIndexMappingsTool = getIndexMappingsTool;