"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIndexSearchSources = void 0;
var _reactQuery = require("@kbn/react-query");
var _use_onechat_service = require("../use_onechat_service");
var _query_keys = require("../../query_keys");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useIndexSearchSources = ({
  pattern
}) => {
  const {
    toolsService
  } = (0, _use_onechat_service.useOnechatServices)();
  const enabled = !!pattern && pattern.trim().length > 0;
  const result = (0, _reactQuery.useQuery)({
    enabled,
    queryKey: _query_keys.queryKeys.tools.indexSearch.resolveTargets(pattern),
    queryFn: () => toolsService.resolveSearchSources({
      pattern
    })
  });
  return result;
};
exports.useIndexSearchSources = useIndexSearchSources;