"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OtelApmQuickstartFlow = OtelApmQuickstartFlow;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _ebtTools = require("@kbn/ebt-tools");
var _public2 = require("@kbn/observability-shared-plugin/public");
var _use_flow_breadcrumbs = require("../../shared/use_flow_breadcrumbs");
var _feedback_buttons = require("../shared/feedback_buttons");
var _get_started_panel = require("../shared/get_started_panel");
var _use_otel_apm_flow = require("./use_otel_apm_flow");
var _empty_prompt = require("../shared/empty_prompt");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability_onboarding/public/application/quickstart_flows/otel_apm/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function OtelApmQuickstartFlow() {
  var _apmLocator$getRedire;
  (0, _use_flow_breadcrumbs.useFlowBreadcrumb)({
    text: _i18n.i18n.translate('xpack.observability_onboarding.otelApm.breadcrumbs.k8sOtel', {
      defaultMessage: 'Application: OpenTelemetry'
    })
  });
  const {
    services: {
      share,
      context: {
        isServerless
      }
    }
  } = (0, _public.useKibana)();
  const {
    data,
    status,
    error,
    refetch
  } = (0, _use_otel_apm_flow.useOtelApmFlow)();
  const {
    onPageReady
  } = (0, _ebtTools.usePerformanceContext)();
  (0, _react.useEffect)(() => {
    if (data) {
      onPageReady({
        meta: {
          description: `[ttfmp_onboarding] Request to create the onboarding flow succeeded and the flow's UI has rendered`
        }
      });
    }
  }, [data, onPageReady]);
  if (error !== undefined) {
    return /*#__PURE__*/_react.default.createElement(_empty_prompt.EmptyPrompt, {
      onboardingFlowType: "otel_apm",
      error: error,
      onRetryClick: refetch,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 12
      }
    });
  }
  const apmLocator = share.url.locators.get('APM_LOCATOR');
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    paddingSize: "xl",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 5
    }
  }, !isServerless && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    title: _i18n.i18n.translate('xpack.observability_onboarding.otelApmQuickstartFlow.euiCallOut.calloutTitleLabel', {
      defaultMessage: 'Managed OTLP Endpoint is in Tech Preview for Elastic Cloud Hosted'
    }),
    iconType: "info",
    color: "warning",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability_onboarding.otelApmQuickstartFlow.p.descriptionTextGoesHereLabel",
    defaultMessage: "Managed OTLP Endpoint should not be used in production yet for Elastic Cloud Hosted deployments. For more details, refer to the {motlpDocumentation}.",
    values: {
      motlpDocumentation: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "apmCreateOpenTelemetryAgentInstructionsMOTLPDocsLink",
        target: "_blank",
        href: "https://www.elastic.co/docs/reference/opentelemetry/motlp",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 89,
          columnNumber: 19
        }
      }, _i18n.i18n.translate('xpack.observability_onboarding.otelApmQuickstartFlow.motlpDocumentationLinkLabel', {
        defaultMessage: 'Managed OTLP Endpoint documentation'
      }))
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
    steps: [{
      title: _i18n.i18n.translate('xpack.observability_onboarding.otelApm.download.title', {
        defaultMessage: 'Install the OpenTelemetry SDK'
      }),
      children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, status !== _public2.FETCH_STATUS.SUCCESS && /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
        lines: 2,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 118,
          columnNumber: 53
        }
      }), status === _public2.FETCH_STATUS.SUCCESS && /*#__PURE__*/_react.default.createElement(InstallSDKInstructions, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 119,
          columnNumber: 53
        }
      }))
    }, {
      title: _i18n.i18n.translate('xpack.observability_onboarding.otelApm.configureAgent.title', {
        defaultMessage: 'Configure the OpenTelemetry SDK'
      }),
      children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, status !== _public2.FETCH_STATUS.SUCCESS && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
        lines: 3,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 131,
          columnNumber: 21
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 132,
          columnNumber: 21
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
        lines: 1,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 133,
          columnNumber: 21
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
        lines: 1,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 134,
          columnNumber: 21
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
        lines: 1,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 135,
          columnNumber: 21
        }
      })), status === _public2.FETCH_STATUS.SUCCESS && data !== undefined && /*#__PURE__*/_react.default.createElement(ConfigureSDKInstructions, {
        managedOtlpServiceUrl: data.managedOtlpServiceUrl,
        apiKeyEncoded: data.apiKeyEncoded,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 139,
          columnNumber: 19
        }
      }))
    }, {
      title: _i18n.i18n.translate('xpack.observability_onboarding.otelApm.monitorStepTitle', {
        defaultMessage: 'Visualize your data'
      }),
      children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 153,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.observability_onboarding.otelApm.onceYourKubernetesInfrastructureLabel",
        defaultMessage: "Go to the Service Inventory to explore your traces, logs, and metrics.",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 154,
          columnNumber: 19
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 159,
          columnNumber: 17
        }
      }), /*#__PURE__*/_react.default.createElement(_get_started_panel.GetStartedPanel, {
        onboardingFlowType: "otel_apm",
        onboardingId: data === null || data === void 0 ? void 0 : data.onboardingId,
        dataset: "otel_apm",
        newTab: false,
        isLoading: status !== _public2.FETCH_STATUS.SUCCESS,
        actionLinks: [{
          id: 'services',
          title: _i18n.i18n.translate('xpack.observability_onboarding.otelApm.servicesTitle', {
            defaultMessage: 'View and analyze your services'
          }),
          label: _i18n.i18n.translate('xpack.observability_onboarding.otelApm.servicesLabel', {
            defaultMessage: 'Open Service Inventory'
          }),
          href: (_apmLocator$getRedire = apmLocator === null || apmLocator === void 0 ? void 0 : apmLocator.getRedirectUrl({
            serviceName: undefined
          })) !== null && _apmLocator$getRedire !== void 0 ? _apmLocator$getRedire : ''
        }],
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 160,
          columnNumber: 17
        }
      }))
    }],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_feedback_buttons.FeedbackButtons, {
    flow: "otel_apm",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 7
    }
  }));
}
function InstallSDKInstructions() {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const languageList = [['.NET', 'https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/dotnet'], ['Java', 'https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/java'], ['Node', 'https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/node'], ['PHP', 'https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/php'], ['Python', 'https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/python'], ['Android', 'https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/android'], ['iOS', 'https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/ios']];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability_onboarding.otelApm.download.textPre",
    defaultMessage: "To download and install the SDK, refer to the {edotDocLink} for your language:",
    values: {
      edotDocLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "apmCreateOpenTelemetryAgentInstructionsEDOTDocsLink",
        target: "_blank",
        href: "http://ela.st/edot-sdks",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 214,
          columnNumber: 13
        }
      }, _i18n.i18n.translate('xpack.observability_onboarding.otelApm.EDOTDocumentationLinkLabel', {
        defaultMessage: 'Elastic Distribution of OpenTelemetry documentation'
      }))
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 209,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 227,
      columnNumber: 7
    }
  }, languageList.map(([language, url]) => /*#__PURE__*/_react.default.createElement("div", {
    key: language,
    css: (0, _react2.css)`
              margin-top: ${euiTheme.size.m};
            `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": `apmCreateOpenTelemetryAgentInstructions${language}Link`,
    target: "_blank",
    href: url,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 235,
      columnNumber: 13
    }
  }, language)))));
}
function ConfigureSDKInstructions({
  managedOtlpServiceUrl,
  apiKeyEncoded
}) {
  const items = [{
    setting: 'OTEL_EXPORTER_OTLP_ENDPOINT',
    value: managedOtlpServiceUrl
  }, {
    setting: 'OTEL_EXPORTER_OTLP_HEADERS',
    value: `Authorization=ApiKey ${apiKeyEncoded}`
  }, {
    setting: 'OTEL_RESOURCE_ATTRIBUTES',
    value: 'service.name=<app-name>,service.version=<app-version>,deployment.environment=production'
  }];
  const columns = [{
    field: 'setting',
    width: '23%',
    name: _i18n.i18n.translate('xpack.observability_onboarding.otelApm.configSettings', {
      defaultMessage: 'Configuration setting'
    })
  }, {
    field: 'value',
    width: '55%',
    name: _i18n.i18n.translate('xpack.observability_onboarding.otelApm.configValue', {
      defaultMessage: 'Configuration value'
    }),
    render: (_, {
      value
    }) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "accent",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 288,
        columnNumber: 11
      }
    }, value), value && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": "apmConfigurationValueColumnButton",
      "aria-label": _i18n.i18n.translate('xpack.observability_onboarding.otelApm.copyIconText', {
        defaultMessage: 'Copy to clipboard'
      }),
      color: "text",
      iconType: "copy",
      onClick: () => (0, _eui.copyToClipboard)(value),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 292,
        columnNumber: 13
      }
    }))
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownFormat, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 309,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.observability_onboarding.otelApm.configureAgent.textPre', {
    defaultMessage: 'Set the following variables in your application’s environment to configure the SDK:'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 315,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    items: items,
    columns: columns,
    "data-test-subj": "otel-instructions-table",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 317,
      columnNumber: 7
    }
  }));
}