"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.streamIntoObservable = streamIntoObservable;
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function streamIntoObservable(readable) {
  return new _rxjs.Observable(subscriber => {
    const decodedStream = readable;
    async function processStream() {
      for await (const chunk of decodedStream) {
        subscriber.next(chunk);
      }
    }
    processStream().then(() => {
      subscriber.complete();
    }).catch(error => {
      subscriber.error(error);
    });
  });
}