"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateSetupModeData = exports.toggleSetupMode = exports.showBottomBar = exports.setNewlyDiscoveredClusterUuid = exports.markSetupModeUnsupported = exports.markSetupModeSupported = exports.isSetupModeFeatureEnabled = exports.isInSetupMode = exports.initSetupModeState = exports.hideBottomBar = exports.getSetupModeState = exports.fetchCollectionData = exports.disableElasticsearchInternalCollection = void 0;
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _legacy_shims = require("../legacy_shims");
var _enums = require("../../common/enums");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

let globalState;
let httpService;
let errorHandler;
const setupModeState = {
  supported: false,
  enabled: false,
  data: null,
  callback: null,
  hideBottomBar: false
};
const getSetupModeState = () => setupModeState;
exports.getSetupModeState = getSetupModeState;
const setNewlyDiscoveredClusterUuid = clusterUuid => {
  var _globalState$save, _globalState;
  globalState.cluster_uuid = clusterUuid;
  (_globalState$save = (_globalState = globalState).save) === null || _globalState$save === void 0 ? void 0 : _globalState$save.call(_globalState);
};
exports.setNewlyDiscoveredClusterUuid = setNewlyDiscoveredClusterUuid;
const fetchCollectionData = async (uuid, fetchWithoutClusterUuid = false) => {
  const clusterUuid = globalState.cluster_uuid;
  const ccs = globalState.ccs;
  let url = '../api/monitoring/v1/setup/collection';
  if (uuid) {
    url += `/node/${uuid}`;
  } else if (!fetchWithoutClusterUuid && clusterUuid) {
    url += `/cluster/${clusterUuid}`;
  } else {
    url += '/cluster';
  }
  try {
    const response = await httpService.post(url, {
      body: JSON.stringify({
        ccs
      })
    });
    return response;
  } catch (err) {
    errorHandler(err);
    throw err;
  }
};
exports.fetchCollectionData = fetchCollectionData;
const notifySetupModeDataChange = () => setupModeState.callback && setupModeState.callback();
const updateSetupModeData = async (uuid, fetchWithoutClusterUuid = false) => {
  const data = await fetchCollectionData(uuid, fetchWithoutClusterUuid);
  setupModeState.data = data;
  const hasPermissions = (0, _lodash.get)(data, '_meta.hasPermissions', false);
  if (!hasPermissions) {
    let text = '';
    if (!hasPermissions) {
      text = _i18n.i18n.translate('xpack.monitoring.setupMode.notAvailablePermissions', {
        defaultMessage: 'You do not have the necessary permissions to do this.'
      });
    }
    _legacy_shims.Legacy.shims.toastNotifications.addDanger({
      title: _i18n.i18n.translate('xpack.monitoring.setupMode.notAvailableTitle', {
        defaultMessage: 'Setup mode is not available'
      }),
      text
    });
    return toggleSetupMode(false);
  }
  notifySetupModeDataChange();
  const clusterUuid = globalState.cluster_uuid;
  if (!clusterUuid) {
    const liveClusterUuid = (0, _lodash.get)(data, '_meta.liveClusterUuid');
    const migratedEsNodes = Object.values((0, _lodash.get)(data, 'elasticsearch.byUuid', {})).filter(node => node.isPartiallyMigrated || node.isFullyMigrated);
    if (liveClusterUuid && migratedEsNodes.length > 0) {
      setNewlyDiscoveredClusterUuid(liveClusterUuid);
    }
  }
};
exports.updateSetupModeData = updateSetupModeData;
const hideBottomBar = () => {
  setupModeState.hideBottomBar = true;
  notifySetupModeDataChange();
};
exports.hideBottomBar = hideBottomBar;
const showBottomBar = () => {
  setupModeState.hideBottomBar = false;
  notifySetupModeDataChange();
};
exports.showBottomBar = showBottomBar;
const disableElasticsearchInternalCollection = async () => {
  const clusterUuid = globalState.cluster_uuid;
  const url = `../api/monitoring/v1/setup/collection/${clusterUuid}/disable_internal_collection`;
  try {
    const response = await httpService.post(url);
    return response;
  } catch (err) {
    errorHandler(err);
    throw err;
  }
};
exports.disableElasticsearchInternalCollection = disableElasticsearchInternalCollection;
const toggleSetupMode = inSetupMode => {
  var _globalState$save2, _globalState2;
  setupModeState.enabled = inSetupMode;
  globalState.inSetupMode = inSetupMode;
  (_globalState$save2 = (_globalState2 = globalState).save) === null || _globalState$save2 === void 0 ? void 0 : _globalState$save2.call(_globalState2);
  notifySetupModeDataChange();
  if (inSetupMode) {
    // Intentionally do not await this so we don't block UI operations
    updateSetupModeData();
  }
};
exports.toggleSetupMode = toggleSetupMode;
const markSetupModeSupported = () => {
  setupModeState.supported = true;
};
exports.markSetupModeSupported = markSetupModeSupported;
const markSetupModeUnsupported = () => {
  setupModeState.supported = false;
};
exports.markSetupModeUnsupported = markSetupModeUnsupported;
const initSetupModeState = async (state, http, handleErrors, callback) => {
  globalState = state;
  httpService = http;
  errorHandler = handleErrors;
  if (callback) {
    setupModeState.callback = callback;
  }
  if (globalState.inSetupMode) {
    toggleSetupMode(true);
  }
};
exports.initSetupModeState = initSetupModeState;
const isInSetupMode = (context, gState = globalState) => {
  if ((context === null || context === void 0 ? void 0 : context.setupModeSupported) === false) {
    return false;
  }
  if (setupModeState.enabled) {
    return true;
  }
  return gState.inSetupMode;
};
exports.isInSetupMode = isInSetupMode;
const isSetupModeFeatureEnabled = feature => {
  if (!setupModeState.enabled) {
    return false;
  }
  if (feature === _enums.SetupModeFeature.MetricbeatMigration) {
    if (_legacy_shims.Legacy.shims.isCloud) {
      return false;
    }
  }
  return true;
};
exports.isSetupModeFeatureEnabled = isSetupModeFeatureEnabled;