"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.Expression = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _alert_param_duration = require("../../flyout_expressions/alert_param_duration");
var _enums = require("../../../../common/enums");
var _alert_param_percentage = require("../../flyout_expressions/alert_param_percentage");
var _alert_param_number = require("../../flyout_expressions/alert_param_number");
var _alert_param_textfield = require("../../flyout_expressions/alert_param_textfield");
var _use_derived_index_pattern = require("./use_derived_index_pattern");
var _kuery_bar = require("../../../components/kuery_bar");
var _kuery = require("../../../lib/kuery");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/alerts/components/param_details_form/expression.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FILTER_TYPING_DEBOUNCE_MS = 500;
const Expression = props => {
  const {
    ruleParams,
    paramDetails,
    setRuleParams,
    errors,
    config,
    dataViews
  } = props;
  const {
    derivedIndexPattern
  } = (0, _use_derived_index_pattern.useDerivedIndexPattern)(dataViews, config);
  const alertParamsUi = Object.keys(paramDetails).map(alertParamName => {
    const details = paramDetails[alertParamName];
    const value = ruleParams[alertParamName];
    switch (details === null || details === void 0 ? void 0 : details.type) {
      case _enums.AlertParamType.Duration:
        return /*#__PURE__*/_react.default.createElement(_alert_param_duration.AlertParamDuration, {
          key: alertParamName,
          name: alertParamName,
          duration: value,
          label: details === null || details === void 0 ? void 0 : details.label,
          errors: errors[alertParamName],
          setRuleParams: setRuleParams,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 50,
            columnNumber: 11
          }
        });
      case _enums.AlertParamType.Percentage:
        return /*#__PURE__*/_react.default.createElement(_alert_param_percentage.AlertParamPercentage, {
          key: alertParamName,
          name: alertParamName,
          label: details === null || details === void 0 ? void 0 : details.label,
          percentage: value,
          errors: errors[alertParamName],
          setRuleParams: setRuleParams,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 61,
            columnNumber: 11
          }
        });
      case _enums.AlertParamType.Number:
        return /*#__PURE__*/_react.default.createElement(_alert_param_number.AlertParamNumber, {
          key: alertParamName,
          name: alertParamName,
          details: details,
          value: value,
          errors: errors[alertParamName],
          setRuleParams: setRuleParams,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 72,
            columnNumber: 11
          }
        });
      case _enums.AlertParamType.TextField:
        return /*#__PURE__*/_react.default.createElement(_alert_param_textfield.AlertParamTextField, {
          key: alertParamName,
          name: alertParamName,
          label: details === null || details === void 0 ? void 0 : details.label,
          value: value,
          errors: errors[alertParamName],
          setRuleParams: setRuleParams,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 83,
            columnNumber: 11
          }
        });
    }
  });
  const onFilterChange = (0, _react.useCallback)(filter => {
    if (derivedIndexPattern) setRuleParams('filterQueryText', filter);
    if (derivedIndexPattern) setRuleParams('filterQuery', (0, _kuery.convertKueryToElasticSearchQuery)(filter, derivedIndexPattern) || '');
  }, [setRuleParams, derivedIndexPattern]);

  /* eslint-disable-next-line react-hooks/exhaustive-deps */
  const debouncedOnFilterChange = (0, _react.useCallback)((0, _lodash.debounce)(onFilterChange, FILTER_TYPING_DEBOUNCE_MS), [onFilterChange]);
  const kueryBar = derivedIndexPattern ? /*#__PURE__*/_react.default.createElement(_kuery_bar.KueryBar, {
    value: ruleParams.filterQueryText,
    derivedIndexPattern: derivedIndexPattern,
    onSubmit: onFilterChange,
    onChange: debouncedOnFilterChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 7
    }
  }, alertParamsUi, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.monitoring.alerts.filterLable', {
      defaultMessage: 'Filter'
    }),
    helpText: _i18n.i18n.translate('xpack.monitoring.alerts.filterHelpText', {
      defaultMessage: 'Use a KQL expression to limit the scope of your alert trigger.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 9
    }
  }, kueryBar), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 9
    }
  })));
};

// for lazy loading
// eslint-disable-next-line import/no-default-export
exports.Expression = Expression;
var _default = exports.default = Expression;