"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseAndGetSyntaxErrors = void 0;
var _antlr = require("antlr4");
var _painless_parser = _interopRequireDefault(require("../../antlr/painless_parser"));
var _lexer = require("./lexer");
var _error_listener = require("../../../../common/error_listener");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const parse = code => {
  const inputStream = _antlr.CharStreams.fromString(code);
  const lexer = new _lexer.PainlessLexerEnhanced(inputStream);
  const painlessLangErrorListener = new _error_listener.ANTLRErrorListener();
  const tokenStream = new _antlr.CommonTokenStream(lexer);
  const parser = new _painless_parser.default(tokenStream);
  lexer.removeErrorListeners();
  parser.removeErrorListeners();
  lexer.addErrorListener(painlessLangErrorListener);
  parser.addErrorListener(painlessLangErrorListener);
  const errors = painlessLangErrorListener.getErrors();
  return {
    source: parser.source(),
    errors
  };
};
const parseAndGetSyntaxErrors = code => {
  const {
    errors
  } = parse(code);
  return errors;
};
exports.parseAndGetSyntaxErrors = parseAndGetSyntaxErrors;