"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCombinedRuntimeMappings = getCombinedRuntimeMappings;
var _is_runtime_mappings = require("./is_runtime_mappings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Return a map of runtime_mappings for each of the data view field provided
 * to provide in ES search queries
 * @param {DataView | undefined} dataView - The Kibana data view.
 * @param runtimeMappings - Optional runtime mappings.
 */
function getCombinedRuntimeMappings(dataView, runtimeMappings) {
  let combinedRuntimeMappings = Object.create(null);

  // Add runtime field mappings defined by index pattern
  if (dataView) {
    const computedFields = dataView === null || dataView === void 0 ? void 0 : dataView.getComputedFields();
    if ((computedFields === null || computedFields === void 0 ? void 0 : computedFields.runtimeFields) !== undefined) {
      const dataViewRuntimeMappings = computedFields.runtimeFields;
      if ((0, _is_runtime_mappings.isRuntimeMappings)(dataViewRuntimeMappings)) {
        combinedRuntimeMappings = {
          ...combinedRuntimeMappings,
          ...dataViewRuntimeMappings
        };
      }
    }
  }

  // Use runtime field mappings defined inline from API
  // and override fields with same name from index pattern
  if ((0, _is_runtime_mappings.isRuntimeMappings)(runtimeMappings)) {
    combinedRuntimeMappings = {
      ...combinedRuntimeMappings,
      ...runtimeMappings
    };
  }
  if ((0, _is_runtime_mappings.isRuntimeMappings)(combinedRuntimeMappings)) {
    return combinedRuntimeMappings;
  }
}