"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ViewLink = void 0;
exports.useTableActions = useTableActions;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _mlDataFrameAnalyticsUtils = require("@kbn/ml-data-frame-analytics-utils");
var _kibana = require("../../../contexts/kibana");
var _get_view_link_status = require("../../../data_frame_analytics/pages/analytics_management/components/action_view/get_view_link_status");
var _locator = require("../../../../../common/constants/locator");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/overview/components/analytics_panel/actions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ViewLink = ({
  item
}) => {
  const {
    disabled,
    tooltipContent
  } = (0, _get_view_link_status.getViewLinkStatus)(item);
  const viewJobResultsButtonText = _i18n.i18n.translate('xpack.ml.overview.analytics.resultActions.openJobText', {
    defaultMessage: 'View job results'
  });
  const tooltipText = disabled === false ? viewJobResultsButtonText : tooltipContent;
  const analysisType = (0, _react.useMemo)(() => (0, _mlDataFrameAnalyticsUtils.getAnalysisType)(item.config.analysis), [item]);
  const viewAnalyticsResultsLink = (0, _kibana.useMlLink)({
    page: _locator.ML_PAGES.DATA_FRAME_ANALYTICS_EXPLORATION,
    pageState: {
      jobId: item.id,
      analysisType: analysisType
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: tooltipText,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    href: viewAnalyticsResultsLink,
    size: "xs",
    iconType: "visTable",
    "aria-label": viewJobResultsButtonText,
    "data-test-subj": "mlOverviewAnalyticsJobViewButton",
    isDisabled: disabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 7
    }
  }));
};
exports.ViewLink = ViewLink;
function useTableActions() {
  const mlManagementLocator = (0, _kibana.useMlManagementLocatorInternal)();
  const navigateToPath = (0, _kibana.useNavigateToPath)();
  return [{
    isPrimary: false,
    name: _i18n.i18n.translate('xpack.ml.overview.analytics.viewJobActionName', {
      defaultMessage: 'View job'
    }),
    description: _i18n.i18n.translate('xpack.ml.overview.analytics.viewJobActionName', {
      defaultMessage: 'View job'
    }),
    type: 'icon',
    icon: 'list',
    onClick: async item => {
      const {
        url
      } = await (mlManagementLocator === null || mlManagementLocator === void 0 ? void 0 : mlManagementLocator.getUrl({
        page: _locator.ML_PAGES.DATA_FRAME_ANALYTICS_JOBS_MANAGE,
        pageState: {
          jobId: item.id
        }
      }, 'analytics'));
      await navigateToPath(url);
    }
  }, {
    isPrimary: false,
    name: _i18n.i18n.translate('xpack.ml.overview.analytics.viewResultsActionName', {
      defaultMessage: 'View results'
    }),
    description: _i18n.i18n.translate('xpack.ml.overview.analytics.resultActions.openJobText', {
      defaultMessage: 'View job results'
    }),
    render: item => /*#__PURE__*/_react.default.createElement(ViewLink, {
      item: item,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 101,
        columnNumber: 52
      }
    })
  }];
}