"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricSelector = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _agg_select = require("../agg_select");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/new_job/pages/components/pick_fields_step/components/metric_selector/metric_selector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const MAX_WIDTH = 560;
const MetricSelector = ({
  fields,
  detectorChangeHandler,
  selectedOptions,
  maxWidth,
  removeOptions
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    style: {
      maxWidth: maxWidth !== undefined ? maxWidth : MAX_WIDTH
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.metricSelector.addMetric', {
      defaultMessage: 'Add metric'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_agg_select.AggSelect, {
    fields: fields,
    changeHandler: detectorChangeHandler,
    selectedOptions: selectedOptions,
    removeOptions: removeOptions,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 11
    }
  }))));
};
exports.MetricSelector = MetricSelector;