"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConditionsSection = ConditionsSection;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _condition_expression = require("./condition_expression");
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/components/rule_editor/conditions_section.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/*
 * React component for rendering the form fields for editing the conditions section of a rule.
 */
function ConditionsSection({
  isEnabled,
  conditions,
  addCondition,
  updateCondition,
  deleteCondition
}) {
  if (isEnabled === false) {
    return null;
  }
  let expressions = [];
  if (conditions !== undefined) {
    expressions = conditions.map((condition, index) => {
      return /*#__PURE__*/_react.default.createElement(_condition_expression.ConditionExpression, {
        key: index,
        index: index,
        appliesTo: condition.applies_to,
        operator: condition.operator,
        value: condition.value,
        updateCondition: updateCondition,
        deleteCondition: deleteCondition,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 35,
          columnNumber: 9
        }
      });
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 5
    }
  }, expressions, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: () => addCondition(),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.ruleEditor.conditionsSection.addNewConditionButtonLabel",
    defaultMessage: "Add new condition",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 9
    }
  })));
}
ConditionsSection.propTypes = {
  isEnabled: _propTypes.default.bool.isRequired,
  conditions: _propTypes.default.array,
  addCondition: _propTypes.default.func.isRequired,
  updateCondition: _propTypes.default.func.isRequired,
  deleteCondition: _propTypes.default.func.isRequired
};