"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExportJobsFlyout = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _ml = require("../../../contexts/ml");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/components/import_export_jobs/export_jobs_flyout/export_jobs_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ExportJobsFlyoutContent = (0, _sharedUxUtility.dynamic)(async () => ({
  default: (await Promise.resolve().then(() => _interopRequireWildcard(require('./export_jobs_flyout_content')))).ExportJobsFlyoutContent
}));
const ExportJobsFlyout = ({
  isDisabled,
  ...rest
}) => {
  const [showFlyout, setShowFlyout] = (0, _react.useState)(false);
  const {
    isADEnabled,
    isDFAEnabled
  } = (0, _ml.useEnabledFeatures)();
  function toggleFlyout() {
    setShowFlyout(!showFlyout);
  }
  if (isADEnabled === false && isDFAEnabled === false) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(FlyoutButton, {
    onClick: toggleFlyout,
    isDisabled: isDisabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 7
    }
  }), showFlyout === true && isDisabled === false && /*#__PURE__*/_react.default.createElement(ExportJobsFlyoutContent, (0, _extends2.default)({
    onClose: () => setShowFlyout(false),
    isADEnabled,
    isDFAEnabled
  }, rest, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 9
    }
  })));
};
exports.ExportJobsFlyout = ExportJobsFlyout;
const FlyoutButton = ({
  isDisabled,
  onClick
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "exportAction",
    onClick: onClick,
    isDisabled: isDisabled,
    "data-test-subj": "mlJobsExportButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.importExport.exportButton",
    defaultMessage: "Export jobs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 7
    }
  }));
};