"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.loadFromLibrary = loadFromLibrary;
var _content_management = require("../../../content_management");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function loadFromLibrary(savedObjectId) {
  const {
    item: savedObject,
    meta: {
      outcome,
      aliasPurpose,
      aliasTargetId
    }
  } = await (0, _content_management.getMapClient)().get(savedObjectId);
  if (savedObject.error) {
    throw savedObject.error;
  }
  return {
    attributes: savedObject.attributes,
    sharingSavedObjectProps: {
      aliasTargetId,
      outcome,
      aliasPurpose,
      sourceId: savedObjectId
    },
    managed: Boolean(savedObject.managed),
    references: savedObject.references
  };
}