"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TileRequestTab = TileRequestTab;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _monaco = require("@kbn/monaco");
var _codeEditor = require("@kbn/code-editor");
var _lzString = require("lz-string");
var _kibana_services = require("../../../kibana_services");
var _get_tile_request = require("./get_tile_request");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/inspector/vector_tile_adapter/components/tile_request_tab.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function TileRequestTab(props) {
  try {
    const {
      path,
      body
    } = (0, _get_tile_request.getTileRequest)(props.tileRequest);
    const consoleRequest = `POST ${path}\n${JSON.stringify(body, null, 2)}`;
    let consoleHref;
    if ((0, _kibana_services.getDevToolsCapabilities)().show) {
      var _getShareService$url$;
      const devToolsDataUri = (0, _lzString.compressToEncodedURIComponent)(consoleRequest);
      consoleHref = (_getShareService$url$ = (0, _kibana_services.getShareService)().url.locators.get('CONSOLE_APP_LOCATOR')) === null || _getShareService$url$ === void 0 ? void 0 : _getShareService$url$.useUrl({
        loadFrom: `data:text/plain,${devToolsDataUri}`
      });
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "s",
      wrap: false,
      responsive: true,
      style: {
        height: '100%'
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 45,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 52,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "flexEnd",
      gutterSize: "m",
      wrap: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
      textToCopy: consoleRequest,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 57,
        columnNumber: 17
      }
    }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "xs",
      flush: "right",
      iconType: "copyClipboard",
      onClick: copy,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 21
      }
    }, _i18n.i18n.translate('xpack.maps.inspector.vectorTileRequest.copyToClipboardLabel', {
      defaultMessage: 'Copy to clipboard'
    }))))), consoleHref !== undefined && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "xs",
      flush: "right",
      onClick: () => {
        const navigateToUrl = (0, _kibana_services.getNavigateToUrl)();
        navigateToUrl(consoleHref);
      },
      iconType: "wrench",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 19
      }
    }, _i18n.i18n.translate('xpack.maps.inspector.vectorTileRequest.openInConsoleLabel', {
      defaultMessage: 'Open in Console'
    })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
      languageId: _monaco.XJsonLang.ID,
      value: consoleRequest,
      options: {
        readOnly: true,
        lineNumbers: 'off',
        fontSize: 12,
        minimap: {
          enabled: false
        },
        folding: true,
        scrollBeyondLastLine: false,
        wordWrap: 'on',
        wrappingIndent: 'indent',
        automaticLayout: true
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 93,
        columnNumber: 11
      }
    })));
  } catch (e) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: _i18n.i18n.translate('xpack.maps.inspector.vectorTileRequest.errorMessage', {
        defaultMessage: 'Unable to create Elasticsearch vector tile search request'
      }),
      color: "warning",
      iconType: "question",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 115,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 122,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.maps.inspector.vectorTileRequest.errorTitle', {
      defaultMessage: `Could not convert tile request, ''{tileUrl}'', to Elasticesarch vector tile search request, error: {error}`,
      values: {
        tileUrl: props.tileRequest.tileUrl,
        error: e.message
      }
    })));
  }
}