"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpdateSourceEditor = UpdateSourceEditor;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _force_refresh_checkbox = require("../../../components/force_refresh_checkbox");
var _kibana_services = require("../../../kibana_services");
var _esql_editor = require("./esql_editor");
var _narrow_by_field = require("./narrow_by_field");
var _esql_utils = require("./esql_utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/sources/esql_source/update_source_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function UpdateSourceEditor(props) {
  const [dateFields, setDateFields] = (0, _react.useState)([]);
  const [geoFields, setGeoFields] = (0, _react.useState)([]);
  const [isInitialized, setIsInitialized] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    let ignore = false;
    (0, _kibana_services.getIndexPatternService)().get(props.sourceDescriptor.dataViewId).then(dataView => {
      if (ignore) {
        return;
      }
      const fields = (0, _esql_utils.getFields)(dataView);
      setDateFields(fields.dateFields);
      setGeoFields(fields.geoFields);
      setIsInitialized(true);
    }).catch(err => {
      if (ignore) {
        return;
      }
      setIsInitialized(true);
    });
    return () => {
      ignore = true;
    };
    // only run on mount
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.maps.esqlSearch.sourceEditorTitle', {
    defaultMessage: 'ES|QL'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 3,
    isLoading: !isInitialized,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_esql_editor.ESQLEditor, {
    esql: props.sourceDescriptor.esql,
    onESQLChange: change => {
      setDateFields(change.dateFields);
      setGeoFields(change.geoFields);
      const changes = [{
        propName: 'columns',
        value: change.columns
      }, {
        propName: 'dataViewId',
        value: change.adhocDataViewId
      }, {
        propName: 'esql',
        value: change.esql
      }];
      function ensureField(key, fields) {
        if (props.sourceDescriptor[key] && !fields.includes(props.sourceDescriptor[key])) {
          const value = fields.length ? fields[0] : undefined;
          changes.push({
            propName: key,
            value
          });
          // uncheck narrowing if there are no fields
          if (!value) {
            changes.push({
              propName: key === 'dateField' ? 'narrowByGlobalTime' : 'narrowByMapBounds',
              value: false
            });
          }
        }
      }
      ensureField('dateField', change.dateFields);
      ensureField('geoField', change.geoFields);
      props.onChange(...changes);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_narrow_by_field.NarrowByMapBounds, {
    esql: props.sourceDescriptor.esql,
    field: props.sourceDescriptor.geoField,
    fields: geoFields,
    narrowByField: props.sourceDescriptor.narrowByMapBounds,
    onFieldChange: fieldName => {
      props.onChange({
        propName: 'geoField',
        value: fieldName
      });
    },
    onNarrowByFieldChange: narrowByField => {
      const changes = [{
        propName: 'narrowByMapBounds',
        value: narrowByField
      }];
      // auto select first geo field when enabling narrowByMapBounds and geoField is not set
      if (narrowByField && geoFields.length && !props.sourceDescriptor.geoField) {
        changes.push({
          propName: 'geoField',
          value: geoFields[0]
        });
      }
      props.onChange(...changes);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('xpack.maps.esqlSource.narrowByGlobalSearchLabel', {
      defaultMessage: `Apply global search to ES|QL statement`
    }),
    checked: props.sourceDescriptor.narrowByGlobalSearch,
    onChange: event => {
      props.onChange({
        propName: 'narrowByGlobalSearch',
        value: event.target.checked
      });
    },
    compressed: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_narrow_by_field.NarrowByTime, {
    esql: props.sourceDescriptor.esql,
    field: props.sourceDescriptor.dateField,
    fields: dateFields,
    narrowByField: props.sourceDescriptor.narrowByGlobalTime,
    onFieldChange: fieldName => {
      props.onChange({
        propName: 'dateField',
        value: fieldName
      });
    },
    onNarrowByFieldChange: narrowByField => {
      const changes = [{
        propName: 'narrowByGlobalTime',
        value: narrowByField
      }];
      // auto select first date field when enabling narrowByGlobalTime and dateField is not set
      if (narrowByField && dateFields.length && !props.sourceDescriptor.dateField) {
        changes.push({
          propName: 'dateField',
          value: dateFields[0]
        });
      }
      props.onChange(...changes);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_force_refresh_checkbox.ForceRefreshCheckbox, {
    applyForceRefresh: props.sourceDescriptor.applyForceRefresh,
    setApplyForceRefresh: applyForceRefresh => {
      props.onChange({
        propName: 'applyForceRefresh',
        value: applyForceRefresh
      });
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 7
    }
  }));
}