"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DistanceForm = DistanceForm;
exports.KM_ABBREVIATION = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _panel_strings = require("../../../../../connected_components/panel_strings");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/layers/wizards/spatial_join_wizard/wizard_form/distance_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const KM_ABBREVIATION = exports.KM_ABBREVIATION = _i18n.i18n.translate('xpack.maps.spatialJoin.wizardForm.kilometersAbbreviation', {
  defaultMessage: 'km'
});
function getDistanceAsNumber(distance) {
  return typeof distance === 'string' ? parseFloat(distance) : distance;
}
function DistanceForm(props) {
  const [distance, setDistance] = (0, _react.useState)(props.initialDistance);
  const distanceAsNumber = getDistanceAsNumber(distance);
  const isDistanceInvalid = isNaN(distanceAsNumber) || distanceAsNumber <= 0;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.maps.spatialJoin.wizardForm.distanceLabel', {
      defaultMessage: 'Distance'
    }),
    isInvalid: isDistanceInvalid,
    error: isDistanceInvalid ? [_i18n.i18n.translate('xpack.maps.spatialJoin.wizardForm.invalidDistanceMessage', {
      defaultMessage: 'Value must be a number greater than 0'
    })] : [],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    append: KM_ABBREVIATION,
    "aria-label": _i18n.i18n.translate('xpack.maps.spatialJoin.wizardForm.distanceInputAriaLabel', {
      defaultMessage: 'distance input'
    }),
    isInvalid: isDistanceInvalid,
    min: 0,
    onChange: e => {
      setDistance(e.target.value);
    },
    value: distance,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverFooter, {
    paddingSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: props.onClose,
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 13
    }
  }, _panel_strings.panelStrings.close)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    isDisabled: isDistanceInvalid || props.initialDistance.toString() === distance.toString(),
    onClick: () => {
      props.onDistanceChange(getDistanceAsNumber(distance));
      props.onClose();
    },
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 13
    }
  }, _panel_strings.panelStrings.apply)))));
}