"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BuilderExceptionListItemComponent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _securitysolutionListUtils = require("@kbn/securitysolution-list-utils");
var _and_badge = require("./and_badge");
var _entry_delete_button = require("./entry_delete_button");
var _entry_renderer = require("./entry_renderer");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/lists/public/exceptions/components/builder/exception_item_renderer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MyBeautifulLine = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  &:after {
    background: ${({
  theme
}) => theme.eui.euiColorLightShade};
    content: '';
    width: 2px;
    height: 40px;
    margin: 0 15px;
  }
`;
const MyOverflowContainer = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  overflow: hidden;
  width: 100%;
`;
const BuilderExceptionListItemComponent = exports.BuilderExceptionListItemComponent = /*#__PURE__*/_react.default.memo(({
  allowLargeValueLists,
  httpService,
  autocompleteService,
  exceptionItem,
  osTypes,
  exceptionItemIndex,
  indexPattern,
  isOnlyItem,
  listType,
  andLogicIncluded,
  onDeleteExceptionItem,
  onChangeExceptionItem,
  setErrorsExist,
  setWarningsExist,
  onlyShowListOperators = false,
  isDisabled = false,
  operatorsList,
  allowCustomOptions = false,
  getExtendedFields,
  showValueListModal
}) => {
  const handleEntryChange = (0, _react.useCallback)((entry, entryIndex) => {
    const updatedEntries = [...exceptionItem.entries.slice(0, entryIndex), {
      ...entry
    }, ...exceptionItem.entries.slice(entryIndex + 1)];
    const updatedExceptionItem = {
      ...exceptionItem,
      entries: updatedEntries
    };
    onChangeExceptionItem(updatedExceptionItem, exceptionItemIndex);
  }, [onChangeExceptionItem, exceptionItem, exceptionItemIndex]);
  const handleDeleteEntry = (0, _react.useCallback)((entryIndex, parentIndex) => {
    const updatedExceptionItem = (0, _securitysolutionListUtils.getUpdatedEntriesOnDelete)(exceptionItem, entryIndex, parentIndex);
    onDeleteExceptionItem(updatedExceptionItem, exceptionItemIndex);
  }, [exceptionItem, onDeleteExceptionItem, exceptionItemIndex]);
  const entries = (0, _react.useMemo)(() => {
    const hasIndexPatternAndEntries = indexPattern != null && exceptionItem.entries.length > 0;
    return hasIndexPatternAndEntries ? (0, _securitysolutionListUtils.getFormattedBuilderEntries)(indexPattern, exceptionItem.entries, allowCustomOptions) : [];
  }, [exceptionItem.entries, indexPattern, allowCustomOptions]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    "data-test-subj": "exceptionEntriesContainer",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 9
    }
  }, andLogicIncluded && /*#__PURE__*/_react.default.createElement(_and_badge.BuilderAndBadgeComponent, {
    entriesLength: exceptionItem.entries.length,
    exceptionItemIndex: exceptionItemIndex,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(MyOverflowContainer, {
    grow: 6,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 13
    }
  }, entries.map((item, index) => {
    var _id;
    const key = (_id = item.id) !== null && _id !== void 0 ? _id : `${index}`;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: key,
      grow: 1,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 143,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs",
      direction: "row",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 144,
        columnNumber: 21
      }
    }, item.nested === 'child' && /*#__PURE__*/_react.default.createElement(MyBeautifulLine, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 145,
        columnNumber: 51
      }
    }), /*#__PURE__*/_react.default.createElement(MyOverflowContainer, {
      grow: 1,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 146,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement(_entry_renderer.BuilderEntryItem, {
      allowLargeValueLists: allowLargeValueLists,
      autocompleteService: autocompleteService,
      entry: item,
      httpService: httpService,
      indexPattern: indexPattern,
      listType: listType,
      onChange: handleEntryChange,
      onlyShowListOperators: onlyShowListOperators,
      setErrorsExist: setErrorsExist,
      setWarningsExist: setWarningsExist,
      osTypes: osTypes,
      isDisabled: isDisabled,
      showLabel: exceptionItemIndex === 0 && index === 0 && item.nested !== 'child',
      operatorsList: operatorsList,
      allowCustomOptions: allowCustomOptions,
      getExtendedFields: getExtendedFields,
      exceptionItemIndex: exceptionItemIndex,
      showValueListModal: showValueListModal,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 147,
        columnNumber: 25
      }
    })), /*#__PURE__*/_react.default.createElement(_entry_delete_button.BuilderEntryDeleteButtonComponent, {
      entries: exceptionItem.entries,
      entryIndex: item.entryIndex,
      exceptionItemIndex: exceptionItemIndex,
      isOnlyItem: isOnlyItem,
      nestedParentIndex: item.parent != null ? item.parent.parentIndex : null,
      onDelete: handleDeleteEntry,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 170,
        columnNumber: 23
      }
    })));
  })))));
});
BuilderExceptionListItemComponent.displayName = 'BuilderExceptionListItem';