"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RevertToBasic = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../../common/constants");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/license_management/public/application/sections/license_dashboard/revert_to_basic/revert_to_basic.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class RevertToBasic extends _react.default.PureComponent {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "cancel", () => {
      this.props.uploadLicenseStatus({});
    });
  }
  acknowledgeModal() {
    const {
      needsAcknowledgement,
      messages: [firstLine, ...messages] = [],
      startBasicLicense,
      cancelStartBasicLicense,
      licenseType
    } = this.props;
    if (!needsAcknowledgement) {
      return null;
    }
    const confirmModalTitleId = (0, _eui.htmlIdGenerator)()('confirmModalTitle');
    return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
      title: _i18n.i18n.translate('xpack.licenseMgmt.licenseDashboard.revertToBasic.confirmModalTitle', {
        defaultMessage: 'Confirm Revert to Basic License'
      }),
      onCancel: cancelStartBasicLicense,
      onConfirm: () => startBasicLicense(licenseType, true),
      cancelButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.licenseMgmt.licenseDashboard.revertToBasic.confirmModal.cancelButtonLabel",
        defaultMessage: "Cancel",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 49,
          columnNumber: 11
        }
      }),
      confirmButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.licenseMgmt.licenseDashboard.revertToBasic.confirmModal.confirmButtonLabel",
        defaultMessage: "Confirm",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 55,
          columnNumber: 11
        }
      }),
      "aria-labelledby": confirmModalTitleId,
      titleProps: {
        id: confirmModalTitleId
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 41,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 11
      }
    }, firstLine), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("ul", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 13
      }
    }, messages.map(message => /*#__PURE__*/_react.default.createElement("li", {
      key: message,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 68,
        columnNumber: 17
      }
    }, message))))));
  }
  render() {
    const {
      licenseType,
      shouldShowRevertToBasicLicense,
      startBasicLicense
    } = this.props;
    if (!shouldShowRevertToBasicLicense) {
      return null;
    }
    const description = /*#__PURE__*/_react.default.createElement("span", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 82,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.licenseMgmt.licenseDashboard.revertToBasic.revertToFreeFeaturesDescription",
      defaultMessage: "You\u2019ll revert to our free features and lose access to machine learning, advanced security, and other {subscriptionFeaturesLinkText}.",
      values: {
        subscriptionFeaturesLinkText: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: _constants.EXTERNAL_LINKS.SUBSCRIPTIONS,
          target: "_blank",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 89,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.licenseMgmt.licenseDashboard.revertToBasic.subscriptionFeaturesLinkText",
          defaultMessage: "subscription features",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 90,
            columnNumber: 17
          }
        }))
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 83,
        columnNumber: 9
      }
    }));
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 102,
        columnNumber: 7
      }
    }, this.acknowledgeModal(), /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
      hasBorder: true,
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.licenseMgmt.licenseDashboard.revertToBasic.acknowledgeModalTitle",
        defaultMessage: "Revert to Basic license",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 107,
          columnNumber: 13
        }
      }),
      description: description,
      footer: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        "data-test-subj": "revertToBasicButton",
        onClick: () => startBasicLicense(licenseType),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 114,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.licenseMgmt.licenseDashboard.revertToBasic.acknowledgeModal.revertToBasicButtonLabel",
        defaultMessage: "Revert to Basic",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 118,
          columnNumber: 15
        }
      })),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 104,
        columnNumber: 9
      }
    }));
  }
}
exports.RevertToBasic = RevertToBasic;