"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.lensCMUpdateResultSchema = exports.lensCMUpdateOptionsSchema = exports.lensCMUpdateBodySchema = void 0;
var _lodash = require("lodash");
var _configSchema = require("@kbn/config-schema");
var _contentManagementUtils = require("@kbn/content-management-utils");
var _common = require("./common");
var _utils = require("../../../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const lensCMUpdateOptionsSchema = exports.lensCMUpdateOptionsSchema = _configSchema.schema.object({
  ...(0, _utils.pickFromObjectSchema)((0, _lodash.omit)(_contentManagementUtils.updateOptionsSchema, 'upsert'),
  // `upsert` is not a schema type
  ['references'])
}, {
  unknowns: 'forbid'
});
const lensCMUpdateBodySchema = exports.lensCMUpdateBodySchema = _configSchema.schema.object({
  options: lensCMUpdateOptionsSchema,
  data: _common.lensItemAttributesSchema
}, {
  unknowns: 'forbid'
});
const lensCMUpdateResultSchema = exports.lensCMUpdateResultSchema = (0, _contentManagementUtils.createResultSchema)(_common.lensSavedObjectSchema);