"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.promptIllustrationStyle = exports.pageContentBodyStyles = exports.WorkspacePanel = exports.VisualizationWrapper = exports.InnerWorkspacePanel = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _i18nReact = require("@kbn/i18n-react");
var _interpreter = require("@kbn/interpreter");
var _reactKibanaContextTheme = require("@kbn/react-kibana-context-theme");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _public = require("@kbn/visualizations-plugin/public");
var _chartIcons = require("@kbn/chart-icons");
var _domDragDrop = require("@kbn/dom-drag-drop");
var _ebtTools = require("@kbn/ebt-tools");
var _chartExpressionsCommon = require("@kbn/chart-expressions-common");
var _react2 = require("@emotion/react");
var _chromaJs = _interopRequireDefault(require("chroma-js"));
var _report_performance_metric_util = require("../../../report_performance_metric_util");
var _lens_ui_telemetry = require("../../../lens_ui_telemetry");
var _utils = require("../../../utils");
var _types = require("../../../types");
var _suggestion_helpers = require("../suggestion_helpers");
var _expression_helpers = require("../expression_helpers");
var _workspace_panel_wrapper = require("./workspace_panel_wrapper");
var _render_dark2x = _interopRequireDefault(require("../../../assets/render_dark@2x.png"));
var _render_light2x = _interopRequireDefault(require("../../../assets/render_light@2x.png"));
var _error_helper = require("../../error_helper");
var _expression_renderer_styles = require("../../../expression_renderer_styles");
var _state_management = require("../../../state_management");
var _lens_slice = require("../../../state_management/lens_slice");
var _workspace_errors = require("./workspace_errors");
var _shared_logic = require("../../../state_management/shared_logic");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/editor_frame_service/editor_frame/workspace_panel/workspace_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const dropProps = {
  value: {
    id: 'lnsWorkspace',
    humanData: {
      label: _i18n.i18n.translate('xpack.lens.editorFrame.workspaceLabel', {
        defaultMessage: 'Workspace'
      })
    }
  },
  order: [1, 0, 0, 0]
};
const executionContext = {
  type: 'application',
  child: {
    type: 'lens'
  }
};
const WorkspacePanel = exports.WorkspacePanel = /*#__PURE__*/_react.default.memo(function WorkspacePanel(props) {
  const {
    getSuggestionForField,
    ...restProps
  } = props;
  const [{
    dragging
  }] = (0, _domDragDrop.useDragDropContext)();
  const suggestionForDraggedField = (0, _react.useMemo)(() => dragging && getSuggestionForField(dragging), [dragging, getSuggestionForField]);
  return /*#__PURE__*/_react.default.createElement(InnerWorkspacePanel, (0, _extends2.default)({}, restProps, {
    suggestionForDraggedField: suggestionForDraggedField,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 5
    }
  }));
});

// Exported for testing purposes only.
const InnerWorkspacePanel = exports.InnerWorkspacePanel = /*#__PURE__*/_react.default.memo(function InnerWorkspacePanel({
  framePublicAPI,
  visualizationMap,
  datasourceMap,
  core,
  plugins,
  ExpressionRenderer: ExpressionRendererComponent,
  suggestionForDraggedField,
  lensInspector,
  getUserMessages,
  addUserMessages
}) {
  var _activeVisualization$;
  const dispatchLens = (0, _state_management.useLensDispatch)();
  const isFullscreen = (0, _state_management.useLensSelector)(_state_management.selectIsFullscreenDatasource);
  const visualization = (0, _state_management.useLensSelector)(_state_management.selectVisualization);
  const activeDatasourceId = (0, _state_management.useLensSelector)(_state_management.selectActiveDatasourceId);
  const datasourceStates = (0, _state_management.useLensSelector)(_state_management.selectDatasourceStates);
  const autoApplyEnabled = (0, _state_management.useLensSelector)(_state_management.selectAutoApplyEnabled);
  const changesApplied = (0, _state_management.useLensSelector)(_state_management.selectChangesApplied);
  const triggerApply = (0, _state_management.useLensSelector)(_state_management.selectTriggerApplyChanges);
  const datasourceLayers = (0, _state_management.useLensSelector)(state => (0, _state_management.selectDatasourceLayers)(state, datasourceMap));
  const searchSessionId = (0, _state_management.useLensSelector)(_state_management.selectSearchSessionId);
  const [localState, setLocalState] = (0, _react.useState)({
    expressionToRender: undefined,
    errors: []
  });
  const initialVisualizationRenderComplete = (0, _react.useRef)(false);

  // NOTE: This does not reflect the actual visualization render
  const initialWorkspaceRenderComplete = (0, _react.useRef)();
  const renderDeps = (0, _react.useRef)();
  const {
    dataViews
  } = framePublicAPI;
  renderDeps.current = {
    datasourceMap,
    datasourceStates,
    visualization,
    visualizationMap,
    datasourceLayers,
    dataViews
  };

  // NOTE: initialRenderTime is only set once when the component mounts
  const visualizationRenderStartTime = (0, _react.useRef)(NaN);
  const dataReceivedTime = (0, _react.useRef)(NaN);
  const esTookTime = (0, _react.useRef)(0);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const onRender$ = (0, _react.useCallback)(() => {
    if (renderDeps.current) {
      if (!initialVisualizationRenderComplete.current) {
        initialVisualizationRenderComplete.current = true;
        // NOTE: this metric is only reported for an initial editor load of a pre-existing visualization
        const currentTime = performance.now();
        (0, _ebtTools.reportPerformanceMetricEvent)(core.analytics, {
          eventName: 'lensVisualizationRenderTime',
          duration: currentTime - visualizationRenderStartTime.current,
          key1: 'time_to_data',
          value1: dataReceivedTime.current - visualizationRenderStartTime.current,
          key2: 'time_to_render',
          value2: currentTime - dataReceivedTime.current,
          key3: 'es_took',
          value3: esTookTime.current
        });
      }
      const datasourceEvents = Object.values(renderDeps.current.datasourceMap).reduce((acc, datasource) => {
        var _datasource$getRender, _datasource$getRender2, _datasourceStates$dat;
        if (!renderDeps.current.datasourceStates[datasource.id]) return [];
        return [...acc, ...((_datasource$getRender = (_datasource$getRender2 = datasource.getRenderEventCounters) === null || _datasource$getRender2 === void 0 ? void 0 : _datasource$getRender2.call(datasource, (_datasourceStates$dat = renderDeps.current.datasourceStates[datasource.id]) === null || _datasourceStates$dat === void 0 ? void 0 : _datasourceStates$dat.state)) !== null && _datasource$getRender !== void 0 ? _datasource$getRender : [])];
      }, []);
      let visualizationEvents = [];
      if (renderDeps.current.visualization.activeId) {
        var _renderDeps$current$v, _renderDeps$current$v2, _renderDeps$current$v3;
        visualizationEvents = (_renderDeps$current$v = (_renderDeps$current$v2 = (_renderDeps$current$v3 = renderDeps.current.visualizationMap[renderDeps.current.visualization.activeId]).getRenderEventCounters) === null || _renderDeps$current$v2 === void 0 ? void 0 : _renderDeps$current$v2.call(_renderDeps$current$v3, renderDeps.current.visualization.state)) !== null && _renderDeps$current$v !== void 0 ? _renderDeps$current$v : [];
      }
      const events = ['vis_editor', ...datasourceEvents, ...visualizationEvents];
      const adHocDataViews = Object.values(renderDeps.current.dataViews.indexPatterns || {}).filter(indexPattern => !indexPattern.isPersisted);
      adHocDataViews.forEach(() => {
        events.push('ad_hoc_data_view');
      });
      (0, _lens_ui_telemetry.trackUiCounterEvents)(events);
    }
  }, [core.analytics]);
  const removeSearchWarningMessagesRef = (0, _react.useRef)();
  const removeExpressionBuildErrorsRef = (0, _react.useRef)();
  const onData$ = (0, _react.useCallback)((_data, adapters) => {
    if (renderDeps.current) {
      dataReceivedTime.current = performance.now();
      const [defaultLayerId] = Object.keys(renderDeps.current.datasourceLayers);
      const datasource = Object.values(renderDeps.current.datasourceMap)[0];
      const datasourceState = Object.values(renderDeps.current.datasourceStates)[0].state;
      let requestWarnings = [];
      if (adapters !== null && adapters !== void 0 && adapters.requests) {
        requestWarnings = (0, _utils.getSearchWarningMessages)(adapters.requests, datasource, datasourceState, {
          searchService: plugins.data.search
        });
        const timings = (0, _report_performance_metric_util.getSuccessfulRequestTimings)(adapters);
        esTookTime.current = timings ? timings.esTookTotal : 0;
      }
      if (requestWarnings.length) {
        removeSearchWarningMessagesRef.current = addUserMessages(requestWarnings);
      } else if (removeSearchWarningMessagesRef.current) {
        removeSearchWarningMessagesRef.current();
        removeSearchWarningMessagesRef.current = undefined;
      }
      if (adapters && adapters.tables) {
        var _adapters$tables;
        dispatchLens((0, _state_management.onActiveDataChange)({
          activeData: (0, _shared_logic.getActiveDataFromDatatable)(defaultLayerId, (_adapters$tables = adapters.tables) === null || _adapters$tables === void 0 ? void 0 : _adapters$tables.tables)
        }));
      }
    }
  }, [addUserMessages, dispatchLens, plugins.data.search]);
  const shouldApplyExpression = autoApplyEnabled || !initialWorkspaceRenderComplete.current || triggerApply;
  const activeVisualization = visualization.activeId ? visualizationMap[visualization.activeId] : null;
  const workspaceErrors = (0, _react.useCallback)(() => getUserMessages(['visualization', 'visualizationInEditor'], {
    severity: 'error'
  }), [getUserMessages]);

  // if the expression is undefined, it means we hit an error that should be displayed to the user
  const unappliedExpression = (0, _react.useMemo)(() => {
    // shouldn't build expression if there is any type of error other than an expression build error
    // (in which case we try again every time because the config might have changed)
    if (workspaceErrors().every(error => error.uniqueId === _utils.EXPRESSION_BUILD_ERROR_ID)) {
      try {
        const ast = (0, _expression_helpers.buildExpression)({
          visualization: activeVisualization,
          visualizationState: visualization.state,
          datasourceMap,
          datasourceStates,
          datasourceLayers,
          indexPatterns: dataViews.indexPatterns,
          dateRange: framePublicAPI.dateRange,
          nowInstant: plugins.data.nowProvider.get(),
          searchSessionId,
          forceDSL: framePublicAPI.forceDSL
        });
        if (ast) {
          // expression has to be turned into a string for dirty checking - if the ast is rebuilt,
          // turning it into a string will make sure the expression renderer only re-renders if the
          // expression actually changed.
          return (0, _interpreter.toExpression)(ast);
        } else {
          return null;
        }
      } catch (e) {
        removeExpressionBuildErrorsRef.current = addUserMessages([{
          uniqueId: _utils.EXPRESSION_BUILD_ERROR_ID,
          severity: 'error',
          fixableInEditor: true,
          displayLocations: [{
            id: 'visualization'
          }],
          shortMessage: _i18n.i18n.translate('xpack.lens.editorFrame.buildExpressionError', {
            defaultMessage: 'An unexpected error occurred while preparing the chart'
          }),
          longMessage: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", {
            "data-test-subj": "expression-failure",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 366,
              columnNumber: 17
            }
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.lens.editorFrame.expressionFailure",
            defaultMessage: "An error occurred in the expression",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 367,
              columnNumber: 19
            }
          })), /*#__PURE__*/_react.default.createElement("p", {
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 373,
              columnNumber: 17
            }
          }, e.toString()))
        }]);
      }
    }
  }, [workspaceErrors, activeVisualization, visualization.state, datasourceMap, datasourceStates, datasourceLayers, dataViews.indexPatterns, framePublicAPI.dateRange, framePublicAPI.forceDSL, plugins.data.nowProvider, searchSessionId, addUserMessages]);
  const isSaveable = Boolean(unappliedExpression);
  (0, _react.useEffect)(() => {
    dispatchLens((0, _state_management.setSaveable)(isSaveable));
  }, [isSaveable, dispatchLens]);
  (0, _react.useEffect)(() => {
    if (!autoApplyEnabled) {
      dispatchLens((0, _lens_slice.setChangesApplied)(unappliedExpression === localState.expressionToRender));
    }
  });
  (0, _react.useEffect)(() => {
    if (shouldApplyExpression) {
      setLocalState(s => ({
        ...s,
        expressionToRender: unappliedExpression,
        errors: workspaceErrors()
      }));
    }
  }, [unappliedExpression, shouldApplyExpression, workspaceErrors]);
  const expressionExists = Boolean(localState.expressionToRender);
  (0, _react.useEffect)(() => {
    // reset expression error if component attempts to run it again
    if (expressionExists && removeExpressionBuildErrorsRef.current) {
      removeExpressionBuildErrorsRef.current();
      removeExpressionBuildErrorsRef.current = undefined;
    }
  }, [expressionExists]);
  (0, _react.useEffect)(() => {
    // null signals an empty workspace which should count as an initial render
    if ((expressionExists || localState.expressionToRender === null) && !initialWorkspaceRenderComplete.current) {
      initialWorkspaceRenderComplete.current = true;
    }
  }, [expressionExists, localState.expressionToRender]);
  const [chartSizeSpec, setChartSize] = (0, _react.useState)();
  const onEvent = (0, _react.useCallback)(event => {
    if (!plugins.uiActions) {
      // ui actions not available, not handling event...
      return;
    }
    if ((0, _types.isLensBrushEvent)(event)) {
      plugins.uiActions.getTrigger(_public.VIS_EVENT_TO_TRIGGER[event.name]).exec({
        data: {
          ...event.data,
          timeFieldName: (0, _utils.inferTimeField)(plugins.data.datatableUtilities, event)
        }
      });
    }
    if ((0, _types.isLensFilterEvent)(event) || (0, _types.isLensMultiFilterEvent)(event)) {
      plugins.uiActions.getTrigger(_public.VIS_EVENT_TO_TRIGGER[event.name]).exec({
        data: {
          ...event.data,
          timeFieldName: (0, _utils.inferTimeField)(plugins.data.datatableUtilities, event)
        }
      });
    }
    if ((0, _types.isLensEditEvent)(event) && activeVisualization !== null && activeVisualization !== void 0 && activeVisualization.onEditAction) {
      dispatchLens((0, _state_management.editVisualizationAction)({
        visualizationId: activeVisualization.id,
        event
      }));
    }
    if ((0, _chartExpressionsCommon.isChartSizeEvent)(event)) {
      setChartSize(event.data);
    }
  }, [plugins.data.datatableUtilities, plugins.uiActions, activeVisualization, dispatchLens]);
  const displayOptions = activeVisualization === null || activeVisualization === void 0 ? void 0 : (_activeVisualization$ = activeVisualization.getDisplayOptions) === null || _activeVisualization$ === void 0 ? void 0 : _activeVisualization$.call(activeVisualization);
  const hasCompatibleActions = (0, _react.useCallback)(async event => {
    if (!plugins.uiActions) {
      // ui actions not available, not handling event...
      return false;
    }
    if (!(0, _types.isLensFilterEvent)(event) && !(0, _types.isLensMultiFilterEvent)(event)) {
      return false;
    }
    return (await plugins.uiActions.getTriggerCompatibleActions(_public.VIS_EVENT_TO_TRIGGER[event.name], event)).length > 0;
  }, [plugins.uiActions]);
  const onDrop = (0, _react.useCallback)(() => {
    if (suggestionForDraggedField) {
      (0, _lens_ui_telemetry.trackUiCounterEvents)('drop_onto_workspace');
      (0, _suggestion_helpers.switchToSuggestion)(dispatchLens, suggestionForDraggedField, {
        clearStagedPreview: true
      });
    }
  }, [suggestionForDraggedField, dispatchLens]);
  const isDarkMode = (0, _reactKibanaContextTheme.useKibanaIsDarkMode)();
  const shadowAlpha20 = (0, _chromaJs.default)(euiTheme.colors.shadow).alpha(0.2).css();
  const renderDragDropPrompt = () => {
    if (chartSizeSpec) {
      setChartSize(undefined);
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      textAlign: "center",
      "data-test-subj": "workspace-drag-drop-prompt",
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 516,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 517,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_chartIcons.DropIllustration, {
      "aria-hidden": true,
      css: [(0, _react2.css)`
                filter: drop-shadow(0 6px 12px ${shadowAlpha20})
                  drop-shadow(0 4px 4px ${shadowAlpha20}) drop-shadow(0 2px 2px ${shadowAlpha20});
              `, promptIllustrationStyle],
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 518,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement("h2", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 528,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("strong", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 529,
        columnNumber: 13
      }
    }, !expressionExists ? _i18n.i18n.translate('xpack.lens.editorFrame.emptyWorkspace', {
      defaultMessage: 'Drop some fields here to start'
    }) : _i18n.i18n.translate('xpack.lens.editorFrame.emptyWorkspaceSimple', {
      defaultMessage: 'Drop field here'
    }))), !expressionExists && /*#__PURE__*/_react.default.createElement("div", {
      css: (0, _react2.css)`
                .domDroppable--active & {
                  filter: blur(5px);
                  transition: filter ${euiTheme.animation.fast} ease-in-out;
                }
              `,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 540,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "subdued",
      component: "p",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 548,
        columnNumber: 15
      }
    }, _i18n.i18n.translate('xpack.lens.editorFrame.emptyWorkspaceHeading', {
      defaultMessage: 'Lens is the recommended editor for creating visualizations'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 553,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 554,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: "https://www.elastic.co/products/kibana/feedback",
      target: "_blank",
      external: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 555,
        columnNumber: 17
      }
    }, _i18n.i18n.translate('xpack.lens.editorFrame.goToForums', {
      defaultMessage: 'Make requests and give feedback'
    }))))));
  };
  const renderApplyChangesPrompt = () => {
    if (chartSizeSpec) {
      setChartSize(undefined);
    }
    const applyChangesString = _i18n.i18n.translate('xpack.lens.editorFrame.applyChanges', {
      defaultMessage: 'Apply changes'
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      textAlign: "center",
      "data-test-subj": "workspace-apply-changes-prompt",
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 582,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 583,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("img", {
      "aria-hidden": true,
      css: promptIllustrationStyle,
      src: isDarkMode ? _render_dark2x.default : _render_light2x.default,
      alt: applyChangesString,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 584,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement("h2", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 590,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("strong", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 591,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.lens.editorFrame.applyChangesWorkspacePrompt', {
      defaultMessage: 'Apply changes to render visualization'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 597,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 598,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "s",
      className: _utils.DONT_CLOSE_DIMENSION_CONTAINER_ON_CLICK_CLASS,
      iconType: "checkInCircleFilled",
      onClick: () => dispatchLens((0, _state_management.applyChanges)()),
      "data-test-subj": "lnsApplyChanges__workspace",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 599,
        columnNumber: 13
      }
    }, applyChangesString))));
  };
  const renderVisualization = () => {
    return /*#__PURE__*/_react.default.createElement(VisualizationWrapper, {
      expression: localState.expressionToRender,
      lensInspector: lensInspector,
      onEvent: onEvent,
      hasCompatibleActions: hasCompatibleActions,
      setLocalState: setLocalState,
      localState: {
        ...localState
      },
      errors: localState.errors,
      ExpressionRendererComponent: ExpressionRendererComponent,
      core: core,
      onRender$: onRender$,
      onData$: onData$,
      onComponentRendered: () => {
        visualizationRenderStartTime.current = performance.now();
      },
      displayOptions: displayOptions,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 616,
        columnNumber: 7
      }
    });
  };
  const [{
    dragging
  }] = (0, _domDragDrop.useDragDropContext)();
  const renderWorkspace = () => {
    var _datasourceMap$active;
    const customWorkspaceRenderer = activeDatasourceId && (_datasourceMap$active = datasourceMap[activeDatasourceId]) !== null && _datasourceMap$active !== void 0 && _datasourceMap$active.getCustomWorkspaceRenderer && dragging ? datasourceMap[activeDatasourceId].getCustomWorkspaceRenderer(datasourceStates[activeDatasourceId].state, dragging, dataViews.indexPatterns) : undefined;
    if (customWorkspaceRenderer) {
      return customWorkspaceRenderer();
    }
    const hasSomethingToRender = localState.expressionToRender !== null;
    const renderWorkspaceContents = hasSomethingToRender ? renderVisualization : !changesApplied ? renderApplyChangesPrompt : renderDragDropPrompt;
    return /*#__PURE__*/_react.default.createElement(_domDragDrop.Droppable, {
      className: (0, _classnames.default)('lnsWorkspacePanel__dragDrop', {
        'lnsWorkspacePanel__dragDrop--fullscreen': isFullscreen
      }),
      css: (0, _react2.css)`
          ${isFullscreen && `border: none !important;`}
        `,
      dataTestSubj: "lnsWorkspace",
      dropTypes: suggestionForDraggedField ? ['field_add'] : undefined,
      onDrop: onDrop,
      value: dropProps.value,
      order: dropProps.order,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 662,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "eui-scrollBar",
      css: [pageContentBodyStyles, isFullscreen && `
            box-shadow: none;
            border-radius: 0;
          `],
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 675,
        columnNumber: 9
      }
    }, renderWorkspaceContents()));
  };
  return /*#__PURE__*/_react.default.createElement(_workspace_panel_wrapper.WorkspacePanelWrapper, {
    framePublicAPI: framePublicAPI,
    visualizationId: visualization.activeId,
    datasourceStates: datasourceStates,
    datasourceMap: datasourceMap,
    visualizationMap: visualizationMap,
    isFullscreen: isFullscreen,
    lensInspector: lensInspector,
    getUserMessages: getUserMessages,
    displayOptions: chartSizeSpec,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 693,
      columnNumber: 5
    }
  }, renderWorkspace());
});
function useReportingState(errors) {
  const [isRenderComplete, setIsRenderComplete] = (0, _react.useState)(Boolean(errors === null || errors === void 0 ? void 0 : errors.length));
  const [hasRequestError, setHasRequestError] = (0, _react.useState)(false);
  const nodeRef = (0, _react.useRef)(null);
  (0, _react.useEffect)(() => {
    if (isRenderComplete && nodeRef.current) {
      nodeRef.current.dispatchEvent(new CustomEvent('renderComplete', {
        bubbles: true
      }));
    }
  }, [isRenderComplete, errors]);
  return {
    isRenderComplete,
    setIsRenderComplete,
    hasRequestError,
    setHasRequestError,
    nodeRef
  };
}
const dataLoadingErrorTitle = _i18n.i18n.translate('xpack.lens.editorFrame.dataFailure', {
  defaultMessage: `An error occurred when loading data`
});
const VisualizationWrapper = ({
  expression,
  lensInspector,
  onEvent,
  hasCompatibleActions,
  setLocalState,
  localState,
  errors,
  ExpressionRendererComponent,
  core,
  onRender$,
  onData$,
  onComponentRendered,
  displayOptions
}) => {
  (0, _react.useEffect)(() => {
    onComponentRendered();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const searchContext = (0, _state_management.useLensSelector)(_state_management.selectExecutionContextSearch);
  // Used for reporting
  const {
    isRenderComplete,
    hasRequestError,
    setIsRenderComplete,
    setHasRequestError,
    nodeRef
  } = useReportingState(errors);
  const onRenderHandler = (0, _react.useCallback)(() => {
    setHasRequestError(false);
    setIsRenderComplete(true);
    onRender$();
  }, [onRender$, setHasRequestError, setIsRenderComplete]);
  const searchSessionId = (0, _state_management.useLensSelector)(_state_management.selectSearchSessionId);
  if (errors.length) {
    const configurationErrorTitle = _i18n.i18n.translate('xpack.lens.editorFrame.configurationFailureErrors', {
      defaultMessage: `A configuration error occurred`
    });
    return /*#__PURE__*/_react.default.createElement("div", {
      "data-shared-items-container": true,
      "data-render-complete": true,
      "data-shared-item": "",
      "data-render-error": configurationErrorTitle,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 789,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_workspace_errors.WorkspaceErrors, {
      errors: errors,
      title: configurationErrorTitle,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 795,
        columnNumber: 9
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "lnsExpressionRenderer eui-scrollBar",
    css: [_expression_renderer_styles.lnsExpressionRendererStyle, `
       .domDroppable--active & {
          filter: blur(${euiTheme.size.xs}) !important;
          opacity: .25 !important;
          transition: filter ${euiTheme.animation.normal} ease-in-out, opacity ${euiTheme.animation.normal} ease-in-out;
        }`],
    "data-shared-items-container": true,
    "data-render-complete": isRenderComplete,
    "data-shared-item": "",
    "data-render-error": hasRequestError ? dataLoadingErrorTitle : undefined,
    ref: nodeRef,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 801,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(ExpressionRendererComponent, {
    padding: displayOptions !== null && displayOptions !== void 0 && displayOptions.noPadding ? undefined : 'm',
    expression: expression,
    allowCache: true,
    searchContext: searchContext,
    searchSessionId: searchSessionId,
    onEvent: onEvent,
    hasCompatibleActions: hasCompatibleActions
    // @ts-expect-error upgrade typescript v4.9.5
    ,
    onData$: onData$,
    onRender$: onRenderHandler,
    inspectorAdapters: lensInspector.getInspectorAdapters(),
    executionContext: executionContext,
    renderMode: "edit",
    renderError: (errorMessage, error) => {
      const errorsFromRequest = (0, _error_helper.getOriginalRequestErrorMessages)(error || null);
      const visibleErrorMessages = errorsFromRequest.length ? errorsFromRequest : errorMessage ? [errorMessage] : [];
      return /*#__PURE__*/_react.default.createElement(_workspace_errors.WorkspaceErrors, {
        errors: visibleErrorMessages,
        title: dataLoadingErrorTitle,
        onRender: () => setHasRequestError(true),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 841,
          columnNumber: 13
        }
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 818,
      columnNumber: 7
    }
  }));
};
exports.VisualizationWrapper = VisualizationWrapper;
const promptIllustrationStyle = ({
  euiTheme
}) => {
  return (0, _react2.css)`
    overflow: visible; // Shows arrow animation when it gets out of bounds
    margin-top: 0;
    margin-bottom: -${euiTheme.size.base};

    margin-right: auto;
    margin-left: auto;
    max-width: 176px;
    max-height: 176px;
  `;
};
exports.promptIllustrationStyle = promptIllustrationStyle;
const pageContentBodyStyles = ({
  euiTheme
}) => {
  return (0, _react2.css)`
    flex-grow: 1;
    display: flex;
    align-items: stretch;
    justify-content: stretch;
    border: ${euiTheme.border.thin};
    border-radius: ${euiTheme.border.radius.medium};
    background: ${euiTheme.colors.emptyShade};
    height: 100%;
    overflow: hidden;
    & > * {
      flex: 1 1 100%;
      display: flex;
      align-items: center;
      justify-content: center;
    }
  `;
};
exports.pageContentBodyStyles = pageContentBodyStyles;