"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Easteregg = Easteregg;
var _react = _interopRequireDefault(require("react"));
var _esQuery = require("@kbn/es-query");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/editor_frame_service/editor_frame/easteregg/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const Bee = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./bee'))));
const ELK_BEE_REGEX = /^What\'s (an|(\d+)) elk bees?\?$/;
function Bees({
  query
}) {
  if (!query || typeof query !== 'object' || typeof query.query !== 'string') {
    return null;
  }
  const match = ELK_BEE_REGEX.exec(query.query);
  if (!match) {
    return null;
  }
  let amount = parseInt(match[2] || '1', 10);
  if (isNaN(amount)) {
    amount = 0;
  }
  amount = Math.max(1, Math.min(50, amount));
  return /*#__PURE__*/_react.default.createElement(_react.default.Suspense, {
    fallback: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 5
    }
  }, new Array(amount).fill(undefined).map((v, i) => /*#__PURE__*/_react.default.createElement(Bee, {
    key: i,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 9
    }
  })));
}
function Easteregg(props) {
  if ((0, _esQuery.isOfAggregateQueryType)(props.query)) {
    return null;
  }
  return (
    /*#__PURE__*/
    // Do not break Lens for an easteregg
    _react.default.createElement(_eui.EuiErrorBoundary, {
      style: {
        display: 'none'
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 44,
        columnNumber: 5
      }
    }, /*#__PURE__*/_react.default.createElement(Bees, {
      query: props.query,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 45,
        columnNumber: 7
      }
    }))
  );
}