"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Section = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _side_nav_context = require("../lib/side_nav_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/pages/metrics/metric_detail/components/section.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const Section = ({
  children,
  metrics,
  navLabel,
  sectionLabel,
  onChangeRangeTime,
  isLiveStreaming,
  stopLiveStreaming
}) => {
  const {
    addNavItem
  } = (0, _react.useContext)(_side_nav_context.SideNavContext);
  const subNavItems = _react.Children.toArray(children).reduce((accumulatedChildren, child) => {
    var _metrics$find;
    if (! /*#__PURE__*/(0, _react.isValidElement)(child)) {
      return accumulatedChildren;
    }
    const metric = (_metrics$find = metrics === null || metrics === void 0 ? void 0 : metrics.find(m => m.id === child.props.id)) !== null && _metrics$find !== void 0 ? _metrics$find : null;
    if (metric === null) {
      return accumulatedChildren;
    }
    if (!child.props.label) {
      return accumulatedChildren;
    }
    return [...accumulatedChildren, {
      id: child.props.id,
      name: child.props.label,
      onClick: () => {
        const el = document.getElementById(child.props.id);
        if (el) {
          el.scrollIntoView();
        }
      }
    }];
  }, []);
  const childrenWithProps = _react.Children.map(children, child => /*#__PURE__*/(0, _react.isValidElement)(child) ? /*#__PURE__*/(0, _react.cloneElement)(child, {
    // @ts-expect-error upgrade typescript v4.9.5
    metrics,
    onChangeRangeTime,
    isLiveStreaming,
    stopLiveStreaming
  }) : null);
  if (metrics && subNavItems.length) {
    addNavItem({
      id: navLabel,
      name: navLabel,
      items: subNavItems
    });
    return /*#__PURE__*/_react.default.createElement("div", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("h1", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 11
      }
    }, sectionLabel)), childrenWithProps);
  }
  return null;
};
exports.Section = Section;