"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TemplateDetailsContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _analytics = require("@kbn/analytics");
var _eui = require("@elastic/eui");
var _constants = require("../../../../../../common/constants");
var _shared_imports = require("../../../../../shared_imports");
var _components = require("../../../../components");
var _api = require("../../../../services/api");
var _app_context = require("../../../../app_context");
var _shared = require("../../../../components/shared");
var _components2 = require("../components");
var _tabs = require("./tabs");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/sections/home/template_list/template_details/template_details_content.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SUMMARY_TAB_ID = 'summary';
const MAPPINGS_TAB_ID = 'mappings';
const ALIASES_TAB_ID = 'aliases';
const SETTINGS_TAB_ID = 'settings';
const PREVIEW_TAB_ID = 'preview';
const TABS = [{
  id: SUMMARY_TAB_ID,
  name: _i18n.i18n.translate('xpack.idxMgmt.templateDetails.summaryTabTitle', {
    defaultMessage: 'Summary'
  })
}, {
  id: SETTINGS_TAB_ID,
  name: _i18n.i18n.translate('xpack.idxMgmt.templateDetails.settingsTabTitle', {
    defaultMessage: 'Settings'
  })
}, {
  id: MAPPINGS_TAB_ID,
  name: _i18n.i18n.translate('xpack.idxMgmt.templateDetails.mappingsTabTitle', {
    defaultMessage: 'Mappings'
  })
}, {
  id: ALIASES_TAB_ID,
  name: _i18n.i18n.translate('xpack.idxMgmt.templateDetails.aliasesTabTitle', {
    defaultMessage: 'Aliases'
  })
}, {
  id: PREVIEW_TAB_ID,
  name: _i18n.i18n.translate('xpack.idxMgmt.templateDetails.previewTabTitle', {
    defaultMessage: 'Preview'
  })
}];
const tabToUiMetricMap = {
  [SUMMARY_TAB_ID]: _constants.UIM_TEMPLATE_DETAIL_PANEL_SUMMARY_TAB,
  [SETTINGS_TAB_ID]: _constants.UIM_TEMPLATE_DETAIL_PANEL_SETTINGS_TAB,
  [MAPPINGS_TAB_ID]: _constants.UIM_TEMPLATE_DETAIL_PANEL_MAPPINGS_TAB,
  [ALIASES_TAB_ID]: _constants.UIM_TEMPLATE_DETAIL_PANEL_ALIASES_TAB,
  [PREVIEW_TAB_ID]: _constants.UIM_TEMPLATE_DETAIL_PANEL_PREVIEW_TAB
};
const TemplateDetailsContent = ({
  template: {
    name: templateName,
    isLegacy
  },
  onClose,
  editTemplate,
  cloneTemplate,
  reload
}) => {
  const {
    uiMetricService
  } = (0, _app_context.useServices)();
  const {
    error,
    data: templateDetails,
    isLoading
  } = (0, _api.useLoadIndexTemplate)(templateName, isLegacy);
  const isCloudManaged = (templateDetails === null || templateDetails === void 0 ? void 0 : templateDetails._kbnMeta.type) === 'cloudManaged';
  const templateType = templateDetails === null || templateDetails === void 0 ? void 0 : templateDetails._kbnMeta.type;
  const [templateToDelete, setTemplateToDelete] = (0, _react.useState)([]);
  const [activeTab, setActiveTab] = (0, _react.useState)(SUMMARY_TAB_ID);
  const [isPopoverOpen, setIsPopOverOpen] = (0, _react.useState)(false);
  const renderHeader = () => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 120,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 121,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("h2", {
      id: "templateDetailsFlyoutTitle",
      "data-test-subj": "title",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 122,
        columnNumber: 11
      }
    }, templateName, templateDetails && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, templateDetails.deprecated && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, "\xA0", /*#__PURE__*/_react.default.createElement(_components2.TemplateDeprecatedBadge, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 129,
        columnNumber: 21
      }
    })), "\xA0", /*#__PURE__*/_react.default.createElement(_components2.TemplateTypeIndicator, {
      templateType: templateDetails._kbnMeta.type,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 133,
        columnNumber: 17
      }
    })))));
  };
  const renderBody = () => {
    if (isLoading) {
      return /*#__PURE__*/_react.default.createElement(_shared_imports.SectionLoading, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 145,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.templateDetails.loadingIndexTemplateDescription",
        defaultMessage: "Loading template\u2026",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 146,
          columnNumber: 11
        }
      }));
    }
    if (error) {
      return /*#__PURE__*/_react.default.createElement(_components.SectionError, {
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.idxMgmt.templateDetails.loadingIndexTemplateErrorMessage",
          defaultMessage: "Error loading template",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 158,
            columnNumber: 13
          }
        }),
        error: error,
        "data-test-subj": "sectionError",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 156,
          columnNumber: 9
        }
      });
    }
    if (templateDetails) {
      const {
        template: {
          settings,
          mappings,
          aliases
        } = {}
      } = templateDetails;
      const tabToComponentMap = {
        [SUMMARY_TAB_ID]: /*#__PURE__*/_react.default.createElement(_tabs.TabSummary, {
          templateDetails: templateDetails,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 173,
            columnNumber: 27
          }
        }),
        [SETTINGS_TAB_ID]: /*#__PURE__*/_react.default.createElement(_shared.TabSettings, {
          settings: settings,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 174,
            columnNumber: 28
          }
        }),
        [MAPPINGS_TAB_ID]: /*#__PURE__*/_react.default.createElement(_shared.TabMappings, {
          mappings: mappings,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 175,
            columnNumber: 28
          }
        }),
        [ALIASES_TAB_ID]: /*#__PURE__*/_react.default.createElement(_shared.TabAliases, {
          aliases: aliases,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 176,
            columnNumber: 27
          }
        }),
        [PREVIEW_TAB_ID]: /*#__PURE__*/_react.default.createElement(_tabs.TabPreview, {
          templateName: templateName,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 177,
            columnNumber: 27
          }
        })
      };
      const tabContent = tabToComponentMap[activeTab];
      const managedTemplateCallout = isCloudManaged && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.idxMgmt.templateDetails.cloudManagedTemplateInfoTitle",
          defaultMessage: "Editing a cloud-managed template is not permitted.",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 186,
            columnNumber: 15
          }
        }),
        color: "primary",
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 184,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.templateDetails.cloudManagedTemplateInfoDescription",
        defaultMessage: "Cloud-managed templates are critical for internal operations.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 194,
          columnNumber: 13
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "m",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 199,
          columnNumber: 11
        }
      }));
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, managedTemplateCallout, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 207,
          columnNumber: 11
        }
      }, TABS.filter(tab => {
        // Legacy index templates don't have the "simulate" template API
        if (isLegacy && tab.id === PREVIEW_TAB_ID) {
          return false;
        }
        return true;
      }).map(tab => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
        onClick: () => {
          uiMetricService.trackMetric(_analytics.METRIC_TYPE.CLICK, tabToUiMetricMap[tab.id]);
          setActiveTab(tab.id);
        },
        isSelected: tab.id === activeTab,
        key: tab.id,
        "data-test-subj": "tab",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 215,
          columnNumber: 15
        }
      }, tab.name))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "l",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 229,
          columnNumber: 11
        }
      }), tabContent);
    }
  };
  const renderFooter = () => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 239,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween",
      alignItems: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 240,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 241,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      iconType: "cross",
      flush: "left",
      onClick: onClose,
      "data-test-subj": "closeDetailsButton",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 242,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.templateDetails.closeButtonLabel",
      defaultMessage: "Close",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 248,
        columnNumber: 15
      }
    }))), templateDetails && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 255,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      id: "manageTemplatePanel",
      button: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        fill: true,
        "data-test-subj": "manageTemplateButton",
        iconType: "arrowDown",
        iconSide: "right",
        onClick: () => setIsPopOverOpen(prev => !prev),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 260,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.templateDetails.manageButtonLabel",
        defaultMessage: "Manage",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 267,
          columnNumber: 21
        }
      })),
      isOpen: isPopoverOpen,
      closePopover: () => setIsPopOverOpen(false),
      panelPaddingSize: "none",
      anchorPosition: "rightUp",
      repositionOnScroll: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 257,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
      initialPanelId: 0,
      panels: [{
        id: 0,
        title: _i18n.i18n.translate('xpack.idxMgmt.templateDetails.manageContextMenuPanelTitle', {
          defaultMessage: 'Template options'
        }),
        items: [{
          name: _i18n.i18n.translate('xpack.idxMgmt.templateDetails.editButtonLabel', {
            defaultMessage: 'Edit'
          }),
          icon: 'pencil',
          'data-test-subj': 'editIndexTemplateButton',
          onClick: () => editTemplate(templateName, isLegacy),
          disabled: isCloudManaged
        }, {
          name: _i18n.i18n.translate('xpack.idxMgmt.templateDetails.cloneButtonLabel', {
            defaultMessage: 'Clone'
          }),
          icon: 'copy',
          onClick: () => cloneTemplate(templateName, isLegacy)
        }, {
          name: _i18n.i18n.translate('xpack.idxMgmt.templateDetails.deleteButtonLabel', {
            defaultMessage: 'Delete'
          }),
          icon: 'trash',
          onClick: () => setTemplateToDelete([{
            name: templateName,
            isLegacy,
            type: templateType
          }]),
          'data-test-subj': 'deleteIndexTemplateButton',
          disabled: isCloudManaged
        }]
      }],
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 279,
        columnNumber: 17
      }
    })))));
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, renderHeader(), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    "data-test-subj": "content",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 335,
      columnNumber: 7
    }
  }, renderBody()), renderFooter(), templateToDelete && templateToDelete.length > 0 ? /*#__PURE__*/_react.default.createElement(_components.TemplateDeleteModal, {
    callback: data => {
      if (data && data.hasDeletedTemplates) {
        reload();
      } else {
        setTemplateToDelete([]);
      }
      onClose();
    },
    templatesToDelete: templateToDelete,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 340,
      columnNumber: 9
    }
  }) : null);
};
exports.TemplateDetailsContent = TemplateDetailsContent;