"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EagerGlobalOrdinalsParameter = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _edit_field = require("../fields/edit_field");
var _documentation = require("../../../../../services/documentation");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/mappings_editor/components/document_fields/field_parameters/eager_global_ordinals_parameter.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const EagerGlobalOrdinalsParameter = ({
  description,
  configPath = 'eager_global_ordinals'
}) => /*#__PURE__*/_react.default.createElement(_edit_field.EditFieldFormRow, {
  title: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.eagerGlobalOrdinalsFieldTitle', {
    defaultMessage: 'Build global ordinals at index time'
  }),
  description: description ? description : _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.eagerGlobalOrdinalsFieldDescription', {
    defaultMessage: 'By default, global ordinals are built at search time, which optimizes for index speed. You can optimize for search performance by building them at index time instead.'
  }),
  docLink: {
    text: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.eagerGlobalOrdinalsDocLinkText', {
      defaultMessage: 'Global ordinals documentation'
    }),
    href: _documentation.documentationService.getEagerGlobalOrdinalsLink()
  },
  formFieldPath: "eager_global_ordinals",
  configPath: configPath,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 25,
    columnNumber: 3
  }
});
exports.EagerGlobalOrdinalsParameter = EagerGlobalOrdinalsParameter;