"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getListItemStyle = void 0;
var _react = require("@emotion/react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getListItemStyle = ({
  border,
  colors,
  size
}) => ({
  dotted: (0, _react.css)`
    border-bottom-style: dashed;
  `,
  field: (0, _react.css)`
    border-bottom: ${border.thin};
    height: calc(${size.xl} * 2);
    margin-top: ${size.xs};
  `,
  fieldEnabled: (0, _react.css)`
    &:hover {
      background-color: ${colors.backgroundBaseHighlighted};
    }
  `,
  fieldHighlighted: (0, _react.css)`
    background-color: ${colors.backgroundBaseHighlighted};
  `,
  fieldDim: (0, _react.css)`
    opacity: 0.3;
    &:hover {
      background-color: initial;
    }
  `,
  wrapper: (0, _react.css)`
    padding-left: ${size.xs};
  `,
  wrapperIndent: (0, _react.css)`
    padding-left: ${size.m};
  `,
  content: (0, _react.css)`
    height: calc(${size.xl} * 2);
    position: relative;
  `,
  contentIndent: (0, _react.css)`
    padding-left: ${size.base};
  `,
  toggle: (0, _react.css)`
    padding-left: ${size.xs};
    width: ${size.l};
  `,
  actions: (0, _react.css)`
    padding-left: ${size.s};
  `
});
exports.getListItemStyle = getListItemStyle;