"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ForcemergeField = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _uuid = require("uuid");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../../../shared_imports");
var _i18n_texts = require("../../../i18n_texts");
var _edit_policy_context = require("../../../edit_policy_context");
var _form = require("../../../form");
var _ = require("../..");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/index_lifecycle_management/public/application/sections/edit_policy/components/phases/shared_fields/forcemerge_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ForcemergeField = ({
  phase
}) => {
  const {
    policy
  } = (0, _edit_policy_context.useEditPolicyContext)();
  const initialToggleValue = (0, _react.useMemo)(() => {
    var _policy$phases$phase, _policy$phases$phase$;
    return ((_policy$phases$phase = policy.phases[phase]) === null || _policy$phases$phase === void 0 ? void 0 : (_policy$phases$phase$ = _policy$phases$phase.actions) === null || _policy$phases$phase$ === void 0 ? void 0 : _policy$phases$phase$.forcemerge) != null;
  }, [policy, phase]);
  const {
    docLinks
  } = (0, _shared_imports.useKibana)().services;
  return /*#__PURE__*/_react.default.createElement(_.DescribedFormRow, {
    title: /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 37,
        columnNumber: 14
      }
    }, _i18n_texts.i18nTexts.editPolicy.forceMergeLabel),
    description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.indexLifecycleMgmt.editPolicy.forceMerge.enableExplanationText",
      defaultMessage: "Reduce the number of segments in each index shard and clean up deleted documents.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 40,
        columnNumber: 11
      }
    }), ' ', /*#__PURE__*/_react.default.createElement(_.LearnMoreLink, {
      docPath: docLinks.links.elasticsearch.ilmForceMerge,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 44,
        columnNumber: 11
      }
    })),
    titleSize: "xs",
    fullWidth: true,
    switchProps: {
      label: _i18n_texts.i18nTexts.editPolicy.forceMergeEnabledFieldLabel,
      'data-test-subj': `${phase}-forceMergeSwitch`,
      initialValue: initialToggleValue
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_form.UseField, {
    path: `phases.${phase}.actions.forcemerge.max_num_segments`,
    component: _shared_imports.NumericField,
    componentProps: {
      fullWidth: false,
      euiFieldProps: {
        'data-test-subj': `${phase}-selectedForceMergeSegments`,
        min: 1
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_form.UseField, {
    path: `_meta.${phase}.bestCompression`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 7
    }
  }, field => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    label: field.label,
    checked: field.value,
    onChange: field.onChange,
    "data-test-subj": `${phase}-bestCompression`,
    id: (0, _uuid.v4)(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: _i18n_texts.i18nTexts.editPolicy.bestCompressionFieldHelpText,
    position: "right",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 15
    }
  })))));
};
exports.ForcemergeField = ForcemergeField;