"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InstructionSet = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _uiTheme = require("@kbn/ui-theme");
var _instruction = require("./instruction");
var _content = require("./content");
var _ = require("../../..");
var StatusCheckStates = _interopRequireWildcard(require("./status_check_states"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/home/public/application/components/tutorial/instruction_set.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
// FIXME: remove this, and access style variables from EUI context
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class InstructionSetUi extends _react.default.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "tabs", void 0);
    (0, _defineProperty2.default)(this, "onSelectedTabChanged", id => {
      this.setState({
        selectedTabId: id
      });
    });
    (0, _defineProperty2.default)(this, "renderTabs", () => {
      return this.tabs.map((tab, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
        onClick: () => this.onSelectedTabChanged(tab.id),
        isSelected: tab.id === this.state.selectedTabId,
        key: index,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 99,
          columnNumber: 7
        }
      }, tab.name));
    });
    (0, _defineProperty2.default)(this, "renderInstructions", () => {
      const instructionVariant = this.props.instructionVariants.find(variant => {
        return variant.id === this.state.selectedTabId;
      });
      if (!instructionVariant) {
        return;
      }
      const steps = instructionVariant.instructions.map((instruction, index) => {
        const step = /*#__PURE__*/_react.default.createElement(_instruction.Instruction, {
          commands: instruction.commands,
          textPre: instruction.textPre,
          textPost: instruction.textPost,
          replaceTemplateStrings: this.props.replaceTemplateStrings,
          customComponentName: instruction.customComponentName,
          variantId: instructionVariant.id,
          isCloudEnabled: this.props.isCloudEnabled,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 223,
            columnNumber: 11
          }
        });
        return {
          title: instruction.title || '',
          children: step,
          key: index
        };
      });
      if (this.props.statusCheckConfig) {
        steps.push(this.renderStatusCheck());
      }
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 247,
          columnNumber: 9
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
        titleSize: "xs",
        steps: steps,
        firstStepNumber: this.props.offset,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 248,
          columnNumber: 9
        }
      }));
    });
    (0, _defineProperty2.default)(this, "renderHeader", () => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        responsive: false,
        wrap: true,
        justifyContent: "spaceBetween",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 255,
          columnNumber: 7
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 256,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "m",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 257,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement("h2", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 258,
          columnNumber: 13
        }
      }, this.props.title))));
    });
    (0, _defineProperty2.default)(this, "renderCallOut", () => {
      if (!this.props.callOut) {
        return null;
      }
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 272,
          columnNumber: 9
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        title: this.props.callOut.title,
        children: this.props.callOut.message,
        iconType: this.props.callOut.iconType,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 273,
          columnNumber: 9
        }
      }));
    });
    this.tabs = this.initializeTabs(props.instructionVariants);
    this.state = this.initializeState(this.tabs);
  }
  initializeTabs(instructionVariants) {
    return instructionVariants.map(variant => ({
      id: variant.id,
      name: (0, _.getDisplayText)(variant.id),
      initialSelected: variant.initialSelected
    }));
  }
  initializeState(tabs) {
    var _tabs$find$id, _tabs$find;
    const initialState = {
      selectedTabId: tabs.length > 0 ? (_tabs$find$id = (_tabs$find = tabs.find(({
        initialSelected
      }) => initialSelected)) === null || _tabs$find === void 0 ? void 0 : _tabs$find.id) !== null && _tabs$find$id !== void 0 ? _tabs$find$id : tabs[0].id : ''
    };
    return initialState;
  }
  renderStatusCheckMessage() {
    var _this$props$statusChe, _this$props$statusChe2;
    let message;
    let color;
    switch (this.props.statusCheckState) {
      case StatusCheckStates.NOT_CHECKED:
      case StatusCheckStates.FETCHING:
        return null;
      // Don't show any message while fetching or if you haven't yet checked.
      case StatusCheckStates.HAS_DATA:
        message = (_this$props$statusChe = this.props.statusCheckConfig) !== null && _this$props$statusChe !== void 0 && _this$props$statusChe.success ? this.props.statusCheckConfig.success : this.props.intl.formatMessage({
          id: 'home.tutorial.instructionSet.successLabel',
          defaultMessage: 'Success'
        });
        color = 'success';
        break;
      case StatusCheckStates.ERROR:
      case StatusCheckStates.NO_DATA:
        message = (_this$props$statusChe2 = this.props.statusCheckConfig) !== null && _this$props$statusChe2 !== void 0 && _this$props$statusChe2.error ? this.props.statusCheckConfig.error : this.props.intl.formatMessage({
          id: 'home.tutorial.instructionSet.noDataLabel',
          defaultMessage: 'No data found'
        });
        color = 'warning';
        break;
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 138,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: message,
      color: color,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 139,
        columnNumber: 9
      }
    }));
  }
  getStepStatus(statusCheckState) {
    switch (statusCheckState) {
      case undefined:
      case StatusCheckStates.NOT_CHECKED:
      case StatusCheckStates.FETCHING:
        return 'incomplete';
      case StatusCheckStates.HAS_DATA:
        return 'complete';
      case StatusCheckStates.NO_DATA:
        return 'warning';
      case StatusCheckStates.ERROR:
        return 'danger';
      default:
        throw new Error(this.props.intl.formatMessage({
          id: 'home.tutorial.unexpectedStatusCheckStateErrorDescription',
          defaultMessage: 'Unexpected status check state {statusCheckState}'
        }, {
          statusCheckState
        }));
    }
  }
  renderStatusCheck() {
    const {
      statusCheckState,
      statusCheckConfig,
      onStatusCheck
    } = this.props;
    const checkStatusStep = /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 176,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_content.Content, {
      text: (statusCheckConfig === null || statusCheckConfig === void 0 ? void 0 : statusCheckConfig.text) || '',
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 177,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 179,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: onStatusCheck,
      isLoading: statusCheckState === StatusCheckStates.FETCHING,
      "data-test-subj": "statusCheckButton",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 180,
        columnNumber: 9
      }
    }, (statusCheckConfig === null || statusCheckConfig === void 0 ? void 0 : statusCheckConfig.btnLabel) || /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "home.tutorial.instructionSet.checkStatusButtonLabel",
      defaultMessage: "Check status",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 186,
        columnNumber: 13
      }
    })), this.renderStatusCheckMessage());
    return {
      title: (statusCheckConfig === null || statusCheckConfig === void 0 ? void 0 : statusCheckConfig.title) || this.props.intl.formatMessage({
        id: 'home.tutorial.instructionSet.statusCheckTitle',
        defaultMessage: 'Status Check'
      }),
      status: this.getStepStatus(statusCheckState),
      children: checkStatusStep,
      key: 'checkStatusStep'
    };
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 284,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
      color: "subdued",
      paddingSize: "none",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 285,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
      css: {
        padding: `0 ${_uiTheme.euiThemeVars.euiSizeL}`
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 286,
        columnNumber: 11
      }
    }, this.renderTabs())), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
      paddingSize: "l",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 288,
        columnNumber: 9
      }
    }, this.renderHeader(), this.renderCallOut(), this.renderInstructions()));
  }
}
const InstructionSet = exports.InstructionSet = (0, _i18nReact.injectI18n)(InstructionSetUi);