"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchBar = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = _interopRequireWildcard(require("react"));
var _apmRum = require("@elastic/apm-rum");
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _useEvent = _interopRequireDefault(require("react-use/lib/useEvent"));
var _useMountedState = _interopRequireDefault(require("react-use/lib/useMountedState"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _ = require(".");
var _lib = require("../lib");
var _search_syntax = require("../search_syntax");
var _strings = require("../strings");
var _suggestions = require("../suggestions");
var _popover_footer = require("./popover_footer");
var _popover_placeholder = require("./popover_placeholder");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/global_search_bar/public/components/search_bar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SearchCharLimitExceededMessage = props => {
  const charLimitMessage = /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement("p", {
    "data-test-subj": "searchCharLimitExceededMessageHeading",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.globalSearchBar.searchBar.searchCharLimitExceededHeading",
    defaultMessage: "Search character limit exceeded",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react2.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.globalSearchBar.searchBar.searchCharLimitExceeded",
    defaultMessage: "Try searching for applications, dashboards, visualizations, and more.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 9
    }
  })));
  return /*#__PURE__*/_react2.default.createElement(_popover_placeholder.PopoverPlaceholder, {
    basePath: props.basePathUrl,
    customPlaceholderMessage: charLimitMessage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 5
    }
  });
};
const EmptyMessage = () => /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
  direction: "column",
  justifyContent: "center",
  css: (0, _react.css)`
      min-height: 300px;
    `,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 73,
    columnNumber: 3
  }
}, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 80,
    columnNumber: 5
  }
}, /*#__PURE__*/_react2.default.createElement(_eui.EuiLoadingSpinner, {
  size: "xl",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 81,
    columnNumber: 7
  }
})));
const SearchBar = opts => {
  const {
    globalSearch,
    taggingApi,
    navigateToUrl,
    reportEvent,
    chromeStyle$,
    ...props
  } = opts;
  const isMounted = (0, _useMountedState.default)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const chromeStyle = (0, _useObservable.default)(chromeStyle$);

  // These hooks are used when on chromeStyle set to 'project'
  const [isVisible, setIsVisible] = (0, _react2.useState)(false);
  const visibilityButtonRef = (0, _react2.useRef)(null);

  // General hooks
  const [initialLoad, setInitialLoad] = (0, _react2.useState)(false);
  const [searchValue, setSearchValue] = (0, _react2.useState)('');
  const [searchRef, setSearchRef] = (0, _react2.useState)(null);
  const [buttonRef, setButtonRef] = (0, _react2.useState)(null);
  const searchSubscription = (0, _react2.useRef)(null);
  const [options, setOptions] = (0, _react2.useState)([]);
  const [searchableTypes, setSearchableTypes] = (0, _react2.useState)([]);
  const [showAppend, setShowAppend] = (0, _react2.useState)(true);
  const UNKNOWN_TAG_ID = '__unknown__';
  const [isLoading, setIsLoading] = (0, _react2.useState)(false);
  const [searchCharLimitExceeded, setSearchCharLimitExceeded] = (0, _react2.useState)(false);
  const styles = (0, _react.css)({
    [(0, _eui.useEuiBreakpoint)(['m', 'l'])]: {
      width: (0, _eui.mathWithUnits)(euiTheme.size.xxl, x => x * 10)
    },
    [(0, _eui.useEuiMinBreakpoint)('xl')]: {
      width: (0, _eui.mathWithUnits)(euiTheme.size.xxl, x => x * 15)
    }
  });
  // Initialize searchableTypes data
  (0, _react2.useEffect)(() => {
    if (initialLoad) {
      const fetch = async () => {
        const types = await globalSearch.getSearchableTypes();
        setSearchableTypes(types);
      };
      fetch();
    }
  }, [globalSearch, initialLoad]);

  // Whenever searchValue changes, isLoading = true
  (0, _react2.useEffect)(() => {
    setIsLoading(true);
  }, [searchValue]);
  const loadSuggestions = (0, _react2.useCallback)(term => {
    return (0, _suggestions.getSuggestions)({
      searchTerm: term,
      searchableTypes,
      tagCache: taggingApi === null || taggingApi === void 0 ? void 0 : taggingApi.cache
    });
  }, [taggingApi, searchableTypes]);
  const setDecoratedOptions = (0, _react2.useCallback)((_options, suggestions, searchTagIds = []) => {
    setOptions([...suggestions.map(_lib.suggestionToOption), ..._options.map(option => {
      var _searchTagIds$filter;
      return (0, _lib.resultToOption)(option, (_searchTagIds$filter = searchTagIds === null || searchTagIds === void 0 ? void 0 : searchTagIds.filter(id => id !== UNKNOWN_TAG_ID)) !== null && _searchTagIds$filter !== void 0 ? _searchTagIds$filter : [], taggingApi === null || taggingApi === void 0 ? void 0 : taggingApi.ui.getTagList);
    })]);
  }, [setOptions, taggingApi]);
  (0, _useDebounce.default)(() => {
    if (initialLoad) {
      // cancel pending search if not completed yet
      if (searchSubscription.current) {
        searchSubscription.current.unsubscribe();
        searchSubscription.current = null;
      }
      if (searchValue.length > globalSearch.searchCharLimit) {
        // setting this will display an error message to the user
        setSearchCharLimitExceeded(true);
        return;
      } else {
        setSearchCharLimitExceeded(false);
      }
      const suggestions = loadSuggestions(searchValue.toLowerCase());
      let aggregatedResults = [];
      if (searchValue.length !== 0) {
        reportEvent.searchRequest();
      }
      const rawParams = (0, _search_syntax.parseSearchParams)(searchValue.toLowerCase(), searchableTypes);
      let tagIds;
      if (taggingApi && rawParams.filters.tags) {
        tagIds = rawParams.filters.tags.map(tagName => {
          var _taggingApi$ui$getTag;
          return (_taggingApi$ui$getTag = taggingApi.ui.getTagIdFromName(tagName)) !== null && _taggingApi$ui$getTag !== void 0 ? _taggingApi$ui$getTag : UNKNOWN_TAG_ID;
        });
      } else {
        tagIds = undefined;
      }
      const searchParams = {
        term: rawParams.term,
        types: rawParams.filters.types,
        tags: tagIds
      };
      searchSubscription.current = globalSearch.find(searchParams, {}).subscribe({
        next: ({
          results
        }) => {
          if (!isMounted()) {
            return;
          }
          if (searchValue.length > 0) {
            aggregatedResults = [...results, ...aggregatedResults].sort(_.sort.byScore);
            setDecoratedOptions(aggregatedResults, suggestions, searchParams.tags);
            return;
          }

          // if searchbar is empty, filter to only applications and sort alphabetically
          results = results.filter(({
            type
          }) => type === 'application');
          aggregatedResults = [...results, ...aggregatedResults].sort(_.sort.byTitle);
          setDecoratedOptions(aggregatedResults, suggestions, searchParams.tags);
        },
        error: err => {
          setIsLoading(false);

          // Not doing anything on error right now because it'll either just show the previous
          // results or empty results which is basically what we want anyways
          _apmRum.apm.captureError(err, {
            labels: {
              SearchValue: searchValue
            }
          });
        },
        complete: () => {
          setIsLoading(false);
        }
      });
    }
  }, 350, [searchValue, loadSuggestions, searchableTypes, initialLoad]);
  const onKeyDown = (0, _react2.useCallback)(event => {
    if (event.key === '/' && (_.isMac ? event.metaKey : event.ctrlKey)) {
      event.preventDefault();
      reportEvent.shortcutUsed();
      if (chromeStyle === 'project' && !isVisible) {
        var _visibilityButtonRef$;
        (_visibilityButtonRef$ = visibilityButtonRef.current) === null || _visibilityButtonRef$ === void 0 ? void 0 : _visibilityButtonRef$.click();
      } else if (searchRef) {
        searchRef.focus();
      } else if (buttonRef) {
        buttonRef.children[0].click();
      }
    }
  }, [chromeStyle, isVisible, buttonRef, searchRef, reportEvent]);
  const onChange = (0, _react2.useCallback)((selection, event) => {
    var _selected$label;
    let selectedRank = null;
    const selected = selection.find(({
      checked
    }, rank) => {
      const isChecked = checked === 'on';
      if (isChecked) {
        selectedRank = rank + 1;
      }
      return isChecked;
    });
    if (!selected) {
      return;
    }
    const selectedLabel = (_selected$label = selected.label) !== null && _selected$label !== void 0 ? _selected$label : null;

    // @ts-ignore - ts error is "union type is too complex to express"
    const {
      url,
      type,
      suggestion
    } = selected;

    // if the type is a suggestion, we change the query on the input and trigger a new search
    // by setting the searchValue (only setting the field value does not trigger a search)
    if (type === '__suggestion__') {
      setSearchValue(suggestion);
      return;
    }

    // errors in tracking should not prevent selection behavior
    try {
      if (type === 'application') {
        var _selected$key;
        const key = (_selected$key = selected.key) !== null && _selected$key !== void 0 ? _selected$key : 'unknown';
        const application = `${key.toLowerCase().replaceAll(' ', '_')}`;
        reportEvent.navigateToApplication({
          application,
          searchValue,
          selectedLabel,
          selectedRank
        });
      } else {
        reportEvent.navigateToSavedObject({
          type,
          searchValue,
          selectedLabel,
          selectedRank
        });
      }
    } catch (err) {
      _apmRum.apm.captureError(err, {
        labels: {
          SearchValue: searchValue
        }
      });
      // eslint-disable-next-line no-console
      console.log('Error trying to track searchbar metrics', err);
    }
    if (event.shiftKey) {
      window.open(url);
    } else if (event.ctrlKey || event.metaKey) {
      window.open(url, '_blank');
    } else {
      navigateToUrl(url);
    }
    document.activeElement.blur();
    if (searchRef) {
      clearField();
      searchRef.dispatchEvent(_.blurEvent);
    }
  }, [reportEvent, navigateToUrl, searchRef, searchValue]);
  const clearField = () => setSearchValue('');
  const keyboardShortcutTooltip = `${_strings.i18nStrings.keyboardShortcutTooltip.prefix}: ${_.isMac ? _strings.i18nStrings.keyboardShortcutTooltip.onMac : _strings.i18nStrings.keyboardShortcutTooltip.onNotMac}`;
  (0, _useEvent.default)('keydown', onKeyDown);
  if (chromeStyle === 'project' && !isVisible) {
    return /*#__PURE__*/_react2.default.createElement(_eui.EuiHeaderSectionItemButton, {
      "aria-label": _strings.i18nStrings.showSearchAriaText,
      buttonRef: visibilityButtonRef,
      color: "text",
      "data-test-subj": "nav-search-reveal",
      onClick: () => {
        setIsVisible(true);
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 343,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiIcon, {
      type: "search",
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 352,
        columnNumber: 9
      }
    }));
  }
  const getAppendForChromeStyle = () => {
    if (chromeStyle === 'project') {
      return /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonIcon, {
        "aria-label": _strings.i18nStrings.closeSearchAriaText,
        color: "text",
        "data-test-subj": "nav-search-conceal",
        iconType: "cross",
        onClick: () => {
          reportEvent.searchBlur();
          setIsVisible(false);
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 360,
          columnNumber: 9
        }
      });
    }
    if (showAppend) {
      return /*#__PURE__*/_react2.default.createElement(_eui.EuiFormLabel, {
        title: keyboardShortcutTooltip,
        css: {
          fontFamily: euiTheme.font.familyCode
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 375,
          columnNumber: 9
        }
      }, _.isMac ? '⌘/' : '^/');
    }
  };
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiSelectableTemplateSitewide, {
    isLoading: isLoading,
    isPreFiltered: true,
    onChange: onChange,
    options: options,
    css: styles,
    popoverButtonBreakpoints: ['xs', 's'],
    singleSelection: true,
    renderOption: option => (0, _eui.euiSelectableTemplateSitewideRenderOptions)(option, searchValue),
    colorModes: chromeStyle !== 'project' ? {
      search: 'dark',
      popover: 'global'
    } : undefined,
    listProps: {
      className: 'eui-yScroll',
      css: (0, _react.css)`
          max-block-size: 75vh;
        `
    },
    searchProps: {
      autoFocus: chromeStyle === 'project',
      value: searchValue,
      onInput: e => setSearchValue(e.currentTarget.value),
      'data-test-subj': 'nav-search-input',
      inputRef: setSearchRef,
      compressed: true,
      'aria-label': _strings.i18nStrings.placeholderText,
      placeholder: _strings.i18nStrings.placeholderText,
      onFocus: () => {
        reportEvent.searchFocus();
        setInitialLoad(true);
        setShowAppend(false);
      },
      onBlur: () => {
        reportEvent.searchBlur();
        setShowAppend(!searchValue.length);
      },
      fullWidth: true,
      append: getAppendForChromeStyle()
    },
    errorMessage: searchCharLimitExceeded ? /*#__PURE__*/_react2.default.createElement(SearchCharLimitExceededMessage, (0, _extends2.default)({}, props, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 423,
        columnNumber: 47
      }
    })) : null,
    emptyMessage: /*#__PURE__*/_react2.default.createElement(EmptyMessage, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 424,
        columnNumber: 21
      }
    }),
    noMatchesMessage: /*#__PURE__*/_react2.default.createElement(_popover_placeholder.PopoverPlaceholder, {
      basePath: props.basePathUrl,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 425,
        columnNumber: 25
      }
    }),
    popoverProps: {
      zIndex: Number(euiTheme.levels.navigation),
      'data-test-subj': 'nav-search-popover',
      panelClassName: 'navSearch__panel',
      repositionOnScroll: true,
      popoverRef: setButtonRef,
      panelStyle: {
        marginTop: '6px'
      }
    },
    popoverButton: /*#__PURE__*/_react2.default.createElement(_eui.EuiHeaderSectionItemButton, {
      "aria-label": _strings.i18nStrings.popoverButton,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 435,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiIcon, {
      type: "search",
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 436,
        columnNumber: 11
      }
    })),
    popoverFooter: /*#__PURE__*/_react2.default.createElement(_popover_footer.PopoverFooter, {
      isMac: _.isMac,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 439,
        columnNumber: 22
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 386,
      columnNumber: 5
    }
  });
};
exports.SearchBar = SearchBar;