"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IncomingDataConfirmationStep = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _confirm_incoming_data = require("../confirm_incoming_data");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/components/agent_enrollment_flyout/steps/incoming_data_confirmation_step.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const IncomingDataConfirmationStep = ({
  agentIds,
  installedPolicy,
  agentDataConfirmed,
  setAgentDataConfirmed,
  troubleshootLink
}) => {
  return {
    title: !agentDataConfirmed ? _i18n.i18n.translate('xpack.fleet.agentEnrollment.stepConfirmIncomingData', {
      defaultMessage: 'Confirm incoming data'
    }) : _i18n.i18n.translate('xpack.fleet.agentEnrollment.stepConfirmIncomingData.completed', {
      defaultMessage: 'Incoming data confirmed'
    }),
    children: agentIds.length > 0 ? /*#__PURE__*/_react.default.createElement(_confirm_incoming_data.ConfirmIncomingData, {
      agentIds: agentIds,
      installedPolicy: installedPolicy,
      agentDataConfirmed: agentDataConfirmed,
      setAgentDataConfirmed: setAgentDataConfirmed,
      troubleshootLink: troubleshootLink,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 41,
        columnNumber: 9
      }
    }) : null,
    status: agentIds.length > 0 ? !agentDataConfirmed ? 'loading' : 'complete' : 'disabled'
  };
};
exports.IncomingDataConfirmationStep = IncomingDataConfirmationStep;