"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatAgentCPU = formatAgentCPU;
exports.formatAgentMemory = formatAgentMemory;
exports.formatBytes = formatBytes;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _components = require("../components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agents/services/agent_metrics.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function formatAgentCPU(metrics, agentPolicy) {
  return typeof (metrics === null || metrics === void 0 ? void 0 : metrics.cpu_avg) !== 'undefined' ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: `${(metrics.cpu_avg * 100).toFixed(4)} %`,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 17,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    tabIndex: 0,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 18,
      columnNumber: 7
    }
  }, (metrics.cpu_avg * 100).toFixed(2), " %")) : /*#__PURE__*/_react.default.createElement(_components.MetricNonAvailable, {
    agentPolicy: agentPolicy,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 21,
      columnNumber: 5
    }
  });
}
function formatAgentMemory(metrics, agentPolicy) {
  return metrics !== null && metrics !== void 0 && metrics.memory_size_byte_avg ? formatBytes(metrics.memory_size_byte_avg) : /*#__PURE__*/_react.default.createElement(_components.MetricNonAvailable, {
    agentPolicy: agentPolicy,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 5
    }
  });
}
function formatBytes(bytes, decimals = 0) {
  if (bytes === 0) return '0 Bytes';
  const k = 1024;
  const dm = decimals < 0 ? 0 : decimals;
  const sizes = ['Bytes', 'KB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB'];
  const i = Math.floor(Math.log(bytes) / Math.log(k));
  return parseFloat((bytes / Math.pow(k, i)).toFixed(dm)) + ' ' + sizes[i];
}