"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SeriesColorPicker = SeriesColorPicker;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_series_storage = require("../hooks/use_series_storage");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/exploratory_view/public/components/shared/exploratory_view/components/series_color_picker.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function SeriesColorPicker({
  seriesId,
  series
}) {
  var _series$color;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    setSeries
  } = (0, _use_series_storage.useSeriesStorage)();
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  const onChange = colorN => {
    setSeries(seriesId, {
      ...series,
      color: colorN
    });
  };
  const color = (_series$color = series.color) !== null && _series$color !== void 0 ? _series$color : euiTheme.colors.vis[`euiColorVis${seriesId}`];
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: EDIT_SERIES_COLOR_LABEL,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "o11ySeriesColorPickerButton",
    size: "s",
    onClick: () => setIsOpen(prevState => !prevState),
    flush: "both",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "stopFilled",
    size: "l",
    color: color,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 9
    }
  })));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: button,
    isOpen: isOpen,
    closePopover: () => setIsOpen(false),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: PICK_A_COLOR_LABEL,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiColorPicker, {
    onChange: onChange,
    color: color,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 9
    }
  })));
}
const PICK_A_COLOR_LABEL = _i18n.i18n.translate('xpack.exploratoryView.pickColor', {
  defaultMessage: 'Pick a color'
});
const EDIT_SERIES_COLOR_LABEL = _i18n.i18n.translate('xpack.exploratoryView.editSeriesColor', {
  defaultMessage: 'Edit color for series'
});