"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mergeEntityDefinitionUpdate = mergeEntityDefinitionUpdate;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function mergeEntityDefinitionUpdate(definition, update) {
  const updatedDefinition = (0, _lodash.mergeWith)(definition, update, (value, other) => {
    // we don't want to merge arrays (metrics, metadata..) but overwrite them
    if (Array.isArray(value)) {
      return other;
    }
  });
  return (0, _lodash.omit)(updatedDefinition, ['state']);
}