"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NotFoundPrompt = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _constants = require("../../../../common/constants");
var _licensing = require("../licensing");
var _react_router_helpers = require("../react_router_helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/shared/not_found/not_found_prompt.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const NotFoundPrompt = ({
  productSupportUrl,
  backToLink = '/',
  backToContent
}) => {
  const {
    hasGoldLicense
  } = (0, _kea.useValues)(_licensing.LicensingLogic);
  const supportUrl = hasGoldLicense ? _constants.LICENSED_SUPPORT_URL : productSupportUrl;
  return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.EmptyPrompt, {
    iconType: "logoElasticsearch",
    title: /*#__PURE__*/_react.default.createElement("h1", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 38,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.enterpriseSearch.notFound.title', {
      defaultMessage: '404 error'
    })),
    body: /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 45,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.enterpriseSearch.notFound.description', {
      defaultMessage: 'The page you’re looking for was not found.'
    })),
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 52,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiButtonTo, {
      to: backToLink,
      fill: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 13
      }
    }, backToContent !== null && backToContent !== void 0 ? backToContent : _i18n.i18n.translate('xpack.enterpriseSearch.notFound.action1', {
      defaultMessage: 'Back to your dashboard'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      href: supportUrl,
      target: "_blank",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.enterpriseSearch.notFound.action2', {
      defaultMessage: 'Contact support'
    })))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 5
    }
  });
};
exports.NotFoundPrompt = NotFoundPrompt;